/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.event.emitters.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.event.emitters.elasticsearch.FakeElasticSearchRESTApplication;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ElasticsearchEventEmitterProcessTest {
    private static Server server;
    private static List<String> responseCollector;
    private HashMap<String, Object> context;
    private Environment env;

    @BeforeClass
    public static void initialize() throws Exception {
        FakeElasticSearchRESTApplication application = new FakeElasticSearchRESTApplication(responseCollector);
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)delegate.createEndpoint((Application)application, JAXRSServerFactoryBean.class);
        String url = "http://localhost:9998" + bean.getAddress();
        bean.setAddress(url);
        server = bean.create();
        server.start();
        System.setProperty("org.jbpm.event.emitters.elasticsearch.url", url);
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (server != null) {
            server.stop();
            server.destroy();
        }
        System.clearProperty("org.jbpm.event.emitters.elasticsearch.url");
    }

    @Before
    public void setUp() throws Exception {
        responseCollector.clear();
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test(timeout=10000L)
    public void testIntegrationWithEventManager() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ksession.getWorkItemManager().registerWorkItemHandler("MyWork", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        while (responseCollector.isEmpty()) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull(responseCollector);
        Assert.assertEquals((long)1L, (long)responseCollector.size());
    }

    static {
        responseCollector = new ArrayList<String>();
    }
}

