/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.humantask;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.SystemEventListenerFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.workitem.wsht.HornetQHTWorkItemHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.Content;
import org.jbpm.task.Task;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.SyncTaskServiceWrapper;
import org.jbpm.task.service.hornetq.AsyncHornetQTaskClient;
import org.jbpm.task.utils.ContentMarshallerHelper;

public class HumanTaskExample {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = HumanTaskExample.readKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test", (int)1000);
            HornetQHTWorkItemHandler hornetQHTWorkItemHandler = new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession);
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)hornetQHTWorkItemHandler);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userId", "krisv");
            params.put("description", "Need a new laptop computer");
            ksession.startProcess("com.sample.humantask", params);
            SystemEventListenerFactory.setSystemEventListener((org.drools.SystemEventListener)new SystemEventListener());
            SyncTaskServiceWrapper taskClient = new SyncTaskServiceWrapper((AsyncTaskService)new AsyncHornetQTaskClient("HumanTaskExample-testClient"));
            taskClient.connect("127.0.0.1", 5445);
            Thread.sleep(1000L);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add("sales");
            TaskSummary task1 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("sales-rep", groups, "en-UK").get(0);
            System.out.println("Sales-rep executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
            taskClient.claim(task1.getId(), "sales-rep", groups);
            Thread.sleep(1000L);
            taskClient.start(task1.getId(), "sales-rep");
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("comment", "Agreed, existing laptop needs replacing");
            results.put("outcome", "Accept");
            ContentData contentData = ContentMarshallerHelper.marshal(results, null);
            taskClient.complete(task1.getId(), "sales-rep", contentData);
            Thread.sleep(2000L);
            TaskSummary task2 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("krisv", "en-UK").get(0);
            System.out.println("krisv executing task " + task2.getName() + "(" + task2.getId() + ": " + task2.getDescription() + ")");
            taskClient.start(task2.getId(), "krisv");
            results = new HashMap();
            results.put("outcome", "Agree");
            contentData = ContentMarshallerHelper.marshal(results, null);
            taskClient.complete(task2.getId(), "krisv", contentData);
            Thread.sleep(2000L);
            groups = new ArrayList();
            groups.add("PM");
            TaskSummary task3 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("john", groups, "en-UK").get(0);
            System.out.println("john executing task " + task3.getName() + "(" + task3.getId() + ": " + task3.getDescription() + ")");
            taskClient.claim(task3.getId(), "john", groups);
            taskClient.start(task3.getId(), "john");
            results = new HashMap();
            results.put("outcome", "Agree");
            contentData = ContentMarshallerHelper.marshal(results, null);
            taskClient.complete(task3.getId(), "john", contentData);
            Thread.sleep(2000L);
            TaskSummary task4 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("sales-rep", "en-UK").get(0);
            System.out.println("sales-rep executing task " + task4.getName() + "(" + task4.getId() + ": " + task4.getDescription() + ")");
            taskClient.start(task4.getId(), "sales-rep");
            Task task = taskClient.getTask(task4.getId());
            Content content = taskClient.getContent(task.getTaskData().getDocumentContentId());
            Object result = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
            Map map = (Map)result;
            for (Map.Entry entry : map.entrySet()) {
                System.out.println(entry.getKey() + " = " + entry.getValue());
            }
            taskClient.complete(task4.getId(), "sales-rep", null);
            Thread.sleep(2000L);
            taskClient.disconnect();
            hornetQHTWorkItemHandler.dispose();
            logger.close();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"humantask/HumanTask.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private static class SystemEventListener
    implements org.drools.SystemEventListener {
        private SystemEventListener() {
        }

        public void debug(String arg0) {
        }

        public void debug(String arg0, Object arg1) {
        }

        public void exception(Throwable arg0) {
        }

        public void exception(String arg0, Throwable arg1) {
        }

        public void info(String arg0) {
        }

        public void info(String arg0, Object arg1) {
        }

        public void warning(String arg0) {
        }

        public void warning(String arg0, Object arg1) {
        }
    }
}

