/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.cdi.impl.jpa;

import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.jpa.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.jpa.JPAExecutorStoreService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.executor.ExecutorAdminService;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.runtime.CommandExecutor;
import org.kie.internal.runtime.cdi.Activate;

@Activate(whenAvailable="org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl")
public class JPAExecutorServiceProducer {
    @Inject
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;

    @Produces
    public ExecutorService produceExecutorService() {
        ExecutorService service = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        return service;
    }

    @Produces
    public ExecutorStoreService produceStoreService() {
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        storeService.setCommandService((CommandExecutor)commandService);
        storeService.setEmf(this.emf);
        return storeService;
    }

    @Produces
    public ExecutorAdminService produceAdminService() {
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        adminService.setCommandService((CommandExecutor)commandService);
        return adminService;
    }

    @Produces
    public ExecutorQueryService produceQueryService() {
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        queryService.setCommandService((CommandExecutor)commandService);
        return queryService;
    }
}

