/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.cdi.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.executor.cdi.CDIUtils;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.process.WorkItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDIPrintOutCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(CDIPrintOutCommand.class);

    public ExecutionResults execute(CommandContext ctx) {
        BeanManager manager = CDIUtils.lookUpBeanManager(ctx);
        String clazz = (String)this.getParameter(ctx, "CDIBeanClassName");
        if (StringUtils.isEmpty((CharSequence)clazz)) {
            clazz = ExecutorService.class.getName();
        }
        try {
            Object cdiBean = CDIUtils.createBean(Class.forName(clazz), manager, new Annotation[0]);
            logger.info("CDI bean created {}", cdiBean);
        }
        catch (Exception e) {
            logger.error("Error while creating CDI bean from jbpm executor", (Throwable)e);
        }
        logger.info("Command executed on executor with data {}", (Object)ctx.getData());
        ExecutionResults executionResults = new ExecutionResults();
        return executionResults;
    }

    protected Object getParameter(CommandContext commandContext, String parameterName) {
        if (commandContext.getData(parameterName) != null) {
            return commandContext.getData(parameterName);
        }
        WorkItem workItem = (WorkItem)commandContext.getData("workItem");
        if (workItem != null) {
            return workItem.getParameter(parameterName);
        }
        return null;
    }
}

