/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.cdi.commands;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanManager;
import org.jbpm.executor.cdi.CDIUtils;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryParam;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(QueryRunCommand.class);

    public ExecutionResults execute(CommandContext ctx) {
        BeanManager manager = CDIUtils.lookUpBeanManager(ctx);
        String clazz = QueryService.class.getName();
        try {
            QueryService cdiBean = (QueryService)CDIUtils.createBean(Class.forName(clazz), manager, new Annotation[0]);
            logger.info("CDI bean created {}", (Object)cdiBean);
            String mapperClass = (String)ctx.getData("mapper");
            if (mapperClass == null) {
                mapperClass = "org.jbpm.kie.services.impl.query.mapper.ProcessInstanceQueryMapper";
            }
            Method m = Class.forName(mapperClass).getMethod("get", new Class[0]);
            QueryResultMapper mapper = (QueryResultMapper)m.invoke(null, new Object[0]);
            Object queryR = cdiBean.query((String)ctx.getData("query"), mapper, new QueryContext(), new QueryParam[0]);
            logger.info("Result of the query is " + queryR);
        }
        catch (Exception e) {
            logger.error("Error while creating CDI bean from jbpm executor", (Throwable)e);
        }
        logger.info("Command executed on executor with data {}", (Object)ctx.getData());
        ExecutionResults executionResults = new ExecutionResults();
        return executionResults;
    }

    protected Object getParameter(CommandContext commandContext, String parameterName) {
        if (commandContext.getData(parameterName) != null) {
            return commandContext.getData(parameterName);
        }
        WorkItem workItem = (WorkItem)commandContext.getData("workItem");
        if (workItem != null) {
            return workItem.getParameter(parameterName);
        }
        return null;
    }
}

