/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.ejb.impl;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.ejb.impl.ClassCacheManagerEJBImpl;
import org.jbpm.executor.ejb.impl.jpa.ExecutorRequestAdminServiceEJBImpl;
import org.jbpm.executor.ejb.impl.jpa.TransactionalCommandServiceExecutorEJBImpl;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.event.ExecutorEventSupport;
import org.jbpm.services.ejb.api.ExecutorServiceEJB;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorAdminService;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.ExecutorStoreService;

@Singleton
@Startup
public class ExecutorServiceEJBImpl
extends ExecutorServiceImpl
implements ExecutorServiceEJB,
ExecutorService,
RequeueAware {
    private ExecutorStoreService storeService;
    private ClassCacheManager classCacheManager;
    private TransactionalCommandService transactionalCommandService;

    @EJB(beanInterface=ExecutorEventSupport.class)
    public void setEventSupport(ExecutorEventSupport eventSupport) {
        super.setEventSupport(eventSupport);
    }

    @EJB(beanInterface=TransactionalCommandServiceExecutorEJBImpl.class)
    public void setCommandService(TransactionalCommandService commandService) {
        this.transactionalCommandService = commandService;
    }

    @PostConstruct
    public void init() {
        ExecutorImpl executor = new ExecutorImpl();
        executor.setExecutorStoreService(this.storeService);
        executor.setEventSupport(this.getEventSupport());
        executor.setTransactionManager(this.transactionalCommandService.getTransactionManager());
        AvailableJobsExecutor jobExecutor = new AvailableJobsExecutor();
        jobExecutor.setClassCacheManager(this.classCacheManager);
        jobExecutor.setQueryService(this.getQueryService());
        jobExecutor.setExecutorStoreService(this.storeService);
        jobExecutor.setEventSupport(this.getEventSupport());
        jobExecutor.setExecutor((Executor)executor);
        executor.setJobProcessor(jobExecutor);
        this.setExecutor((Executor)executor);
        super.init();
    }

    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    @EJB
    public void setQueryService(ExecutorQueryService queryService) {
        super.setQueryService(queryService);
    }

    @EJB(beanInterface=ExecutorRequestAdminServiceEJBImpl.class)
    public void setAdminService(ExecutorAdminService adminService) {
        super.setAdminService(adminService);
    }

    @EJB
    public void setStoreService(ExecutorStoreService storeService) {
        this.storeService = storeService;
    }

    @EJB(beanInterface=ClassCacheManagerEJBImpl.class)
    public void setClassCacheManager(ClassCacheManager classCacheManager) {
        this.classCacheManager = classCacheManager;
    }
}

