/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.events.listeners;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.inject.Inject;
import org.jbpm.executor.annotations.Cancelled;
import org.jbpm.executor.annotations.Pending;
import org.jbpm.executor.annotations.Running;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.events.listeners.ExecutorEventListener;
import org.jbpm.shared.services.impl.events.JbpmServicesEventListener;

public class DefaultExecutorEventListener
extends JbpmServicesEventListener<RequestInfo>
implements ExecutorEventListener {
    @Inject
    private Logger logger;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onRequestPending(@Observes(notifyObserver=Reception.ALWAYS) @Pending RequestInfo r) {
        this.logger.log(Level.INFO, " New Pending Request {0}", r.getId());
    }

    @Override
    public void onRequestRunning(@Observes(notifyObserver=Reception.ALWAYS) @Running RequestInfo r) {
        this.logger.log(Level.INFO, " Request Running{0}", r.getId());
    }

    @Override
    public void onRequestCancelled(@Observes(notifyObserver=Reception.ALWAYS) @Cancelled RequestInfo r) {
        this.logger.log(Level.INFO, " The Request {0} has being Cancelled", r.getId());
    }
}

