/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.drools.core.command.CommandService;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.jpa.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.jpa.JPAExecutorStoreService;
import org.jbpm.executor.impl.mem.InMemoryExecutorAdminServiceImpl;
import org.jbpm.executor.impl.mem.InMemoryExecutorStoreService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.internal.executor.api.ExecutorAdminService;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.executor.api.ExecutorStoreService;
import org.kie.internal.runtime.cdi.Activate;

@Activate(whenAvailable="org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl")
public class JPAExecutorServiceProducer {
    @Inject
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;

    @Produces
    public ExecutorService produceExecutorService() {
        ExecutorService service = ExecutorServiceFactory.newExecutorService(this.emf);
        return service;
    }

    @Produces
    public ExecutorStoreService produceStoreService() {
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        storeService.setCommandService((CommandService)commandService);
        storeService.setEmf(this.emf);
        return storeService;
    }

    @Produces
    public ExecutorAdminService produceAdminService() {
        InMemoryExecutorAdminServiceImpl adminService = new InMemoryExecutorAdminServiceImpl(true);
        InMemoryExecutorStoreService storeService = new InMemoryExecutorStoreService(true);
        adminService.setStoreService(storeService);
        return adminService;
    }

    @Produces
    public ExecutorQueryService produceQueryService() {
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        TransactionalCommandService commandService = new TransactionalCommandService(this.emf);
        queryService.setCommandService((CommandService)commandService);
        return queryService;
    }
}

