/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jms;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.XAConnectionFactory;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.hornetq.jms.server.embedded.EmbeddedJMS;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.jms.BitronixHornetQXAConnectionFactory;
import org.jbpm.executor.impl.jms.JmsAvailableJobsExecutor;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAvaiableJobExecutorTest {
    private static final Logger logger = LoggerFactory.getLogger(JmsAvaiableJobExecutorTest.class);
    private ConnectionFactory factory;
    private Queue queue;
    private EmbeddedJMS jmsServer;
    protected ExecutorService executorService;
    protected PoolingDataSource pds;
    protected EntityManagerFactory emf = null;

    @Before
    public void setUp() throws Exception {
        this.startHornetQServer();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        ((ExecutorImpl)((ExecutorServiceImpl)this.executorService).getExecutor()).setConnectionFactory(this.factory);
        ((ExecutorImpl)((ExecutorServiceImpl)this.executorService).getExecutor()).setQueue(this.queue);
        this.executorService.setThreadPoolSize(0);
        this.executorService.setInterval(10000);
        this.executorService.init();
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
        this.stopHornetQServer();
    }

    @Test
    public void testAsyncAuditProducer() throws Exception {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        ut.commit();
        MessageReceiver receiver = new MessageReceiver();
        receiver.receiveAndProcess(this.queue);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    private void startHornetQServer() throws Exception {
        this.jmsServer = new EmbeddedJMS();
        this.jmsServer.start();
        logger.debug("Started Embedded JMS Server");
        BitronixHornetQXAConnectionFactory.connectionFactory = (XAConnectionFactory)this.jmsServer.lookup("ConnectionFactory");
        PoolingConnectionFactory myConnectionFactory = new PoolingConnectionFactory();
        myConnectionFactory.setClassName("org.jbpm.executor.impl.jms.BitronixHornetQXAConnectionFactory");
        myConnectionFactory.setUniqueName("ConnectionFactory");
        myConnectionFactory.setMaxPoolSize(5);
        myConnectionFactory.setAllowLocalTransactions(true);
        myConnectionFactory.init();
        this.factory = myConnectionFactory;
        this.queue = (Queue)this.jmsServer.lookup("/queue/exampleQueue");
    }

    private void stopHornetQServer() throws Exception {
        ((PoolingConnectionFactory)this.factory).close();
        this.jmsServer.stop();
        this.jmsServer = null;
    }

    private class MessageReceiver {
        private MessageReceiver() {
        }

        void receiveAndProcess(Queue queue) throws Exception {
            Connection qconnetion = JmsAvaiableJobExecutorTest.this.factory.createConnection();
            Session qsession = qconnetion.createSession(true, 1);
            MessageConsumer consumer = qsession.createConsumer((Destination)queue);
            qconnetion.start();
            JmsAvailableJobsExecutor jmsExecutor = new JmsAvailableJobsExecutor();
            jmsExecutor.setClassCacheManager(new ClassCacheManager());
            jmsExecutor.setExecutorStoreService(((ExecutorImpl)((ExecutorServiceImpl)JmsAvaiableJobExecutorTest.this.executorService).getExecutor()).getExecutorStoreService());
            jmsExecutor.setQueryService(((ExecutorServiceImpl)JmsAvaiableJobExecutorTest.this.executorService).getQueryService());
            consumer.setMessageListener((MessageListener)jmsExecutor);
            Thread.sleep(2000L);
            consumer.close();
            qsession.close();
            qconnetion.close();
        }

        public List<Message> receive(Queue queue) throws Exception {
            ArrayList<Message> messages = new ArrayList<Message>();
            Connection qconnetion = JmsAvaiableJobExecutorTest.this.factory.createConnection();
            Session qsession = qconnetion.createSession(true, 1);
            MessageConsumer consumer = qsession.createConsumer((Destination)queue);
            qconnetion.start();
            Message m = null;
            while ((m = consumer.receiveNoWait()) != null) {
                messages.add(m);
            }
            consumer.close();
            qsession.close();
            qconnetion.close();
            return messages;
        }
    }
}

