/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;

@Ignore(value="RHBPMS-5154: Test is not suitable for running as DisabledFollowOnLockOracle10gDialect is not supported by default")
public class ExecutorQueryServiceTest {
    protected ExecutorService executorService;
    private static final int THREADS = 2;
    private static volatile AtomicInteger jobFound = new AtomicInteger(0);
    private PoolingDataSource pds;
    private EntityManagerFactory emf = null;

    @Before
    public void setUp() {
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setThreadPoolSize(2);
        this.executorService.setInterval(3000);
        this.executorService.setTimeunit(TimeUnit.MILLISECONDS);
        this.executorService.init();
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    @Test
    public void singleThreadedExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        RequestInfo request = ((ExecutorServiceImpl)this.executorService).getQueryService().getRequestForProcessing();
        Assert.assertNotNull((Object)request);
    }

    @Test(timeout=10000L)
    public void multiThreadedExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        CountDownLatch latch = new CountDownLatch(2);
        for (int i = 0; i < 2; ++i) {
            QueryServiceExecutorThread runner = new QueryServiceExecutorThread(i, ((ExecutorServiceImpl)this.executorService).getQueryService(), latch);
            Thread t = new Thread((Runnable)runner, i + "-query-executor-runner");
            t.start();
        }
        latch.await();
        Assert.assertEquals((long)1L, (long)jobFound.intValue());
    }

    class QueryServiceExecutorThread
    implements Runnable {
        private int i;
        private ExecutorQueryService queryService;
        private CountDownLatch latch;

        public QueryServiceExecutorThread(int i, ExecutorQueryService queryService, CountDownLatch latch) {
            this.i = i;
            this.queryService = queryService;
            this.latch = latch;
        }

        @Override
        public void run() {
            RequestInfo request = this.queryService.getRequestForProcessing();
            if (request != null) {
                jobFound.incrementAndGet();
            }
            this.latch.countDown();
        }
    }
}

