/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.CountDownProcessEventListener;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class AsyncWorkItemHandlerTest
extends AbstractExecutorBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandler() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Thread.sleep(3000L);
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerWithAbort() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerDuplicatedRegister() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.close();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerDelayed() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithParams.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delayAsync", "4s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerAndReturnNullCommand() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.test.ReturnNullCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testRunProcessWithAsyncHandlerWithBusinessKey() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithBusinessKey.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        String businessKey = UUID.randomUUID().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", businessKey);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Thread.sleep(3000L);
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List jobRequest = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)jobRequest);
        Assert.assertEquals((long)1L, (long)jobRequest.size());
        Assert.assertEquals((Object)businessKey, (Object)((RequestInfo)jobRequest.get(0)).getKey());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)jobRequest.get(0)).getStatus());
    }

    @Test
    public void testRunProcessWithAsyncHandlerWithBusinessKeyAbort() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithBusinessKey.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        String businessKey = UUID.randomUUID().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", businessKey);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List jobRequest = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)jobRequest);
        Assert.assertEquals((long)1L, (long)jobRequest.size());
        Assert.assertEquals((Object)businessKey, (Object)((RequestInfo)jobRequest.get(0)).getKey());
        Assert.assertEquals((Object)STATUS.CANCELLED, (Object)((RequestInfo)jobRequest.get(0)).getStatus());
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerProritizedJobs() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-PrioritizedAsyncTasks.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("async-examples.priority-jobs");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List delayedPrintOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        List printOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", new QueryContext());
        Assert.assertEquals((long)1L, (long)delayedPrintOuts.size());
        Assert.assertEquals((long)1L, (long)printOuts.size());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)delayedPrintOuts.get(0)).getStatus());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)printOuts.get(0)).getStatus());
        countDownListener.waitTillCompleted();
        delayedPrintOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        printOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", new QueryContext());
        Assert.assertEquals((long)1L, (long)delayedPrintOuts.size());
        Assert.assertEquals((long)1L, (long)printOuts.size());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)delayedPrintOuts.get(0)).getStatus());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)printOuts.get(0)).getStatus());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        delayedPrintOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        printOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", new QueryContext());
        Assert.assertEquals((long)1L, (long)delayedPrintOuts.size());
        Assert.assertEquals((long)1L, (long)printOuts.size());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)delayedPrintOuts.get(0)).getStatus());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)printOuts.get(0)).getStatus());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    private ExecutorService buildExecutorService() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        return this.executorService;
    }
}

