/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.event.ExecutorEventSupport;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandCallback;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.Reoccurring;
import org.kie.api.executor.STATUS;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvailableJobsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAvailableJobsExecutor.class);
    protected int retries = Integer.parseInt(System.getProperty("org.kie.executor.retry.count", "3"));
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected ExecutorQueryService queryService;
    protected ClassCacheManager classCacheManager;
    protected ExecutorStoreService executorStoreService;
    protected ExecutorEventSupport eventSupport = new ExecutorEventSupport();

    public void setEventSupport(ExecutorEventSupport eventSupport) {
        this.eventSupport = eventSupport;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public void setClassCacheManager(ClassCacheManager classCacheManager) {
        this.classCacheManager = classCacheManager;
    }

    public void setExecutorStoreService(ExecutorStoreService executorStoreService) {
        this.executorStoreService = executorStoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeGivenJob(RequestInfo request) {
        Throwable exception = null;
        try {
            ClassLoader cl;
            List<CommandCallback> callbacks;
            ExecutionResults results;
            CommandContext ctx;
            Command cmd;
            boolean processReoccurring;
            block36: {
                block35: {
                    block34: {
                        ClassLoaderObjectInputStream in;
                        this.eventSupport.fireBeforeJobExecuted((org.kie.api.executor.RequestInfo)request, null);
                        if (request == null) return;
                        processReoccurring = false;
                        cmd = null;
                        ctx = null;
                        results = null;
                        callbacks = null;
                        cl = this.getClassLoader(request.getDeploymentId());
                        try {
                            logger.debug("Processing Request Id: {}, status {} command {}", new Object[]{request.getId(), request.getStatus(), request.getCommandName()});
                            byte[] reqData = request.getRequestData();
                            if (reqData != null) {
                                in = null;
                                try {
                                    in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(reqData));
                                    ctx = (CommandContext)in.readObject();
                                }
                                catch (IOException iOException) {
                                    logger.warn("Exception while serializing context data", (Throwable)iOException);
                                    this.handleCompletion(processReoccurring, cmd, ctx);
                                    this.eventSupport.fireAfterJobExecuted((org.kie.api.executor.RequestInfo)request, exception);
                                    return;
                                }
                                finally {
                                    if (in != null) {
                                        in.close();
                                    }
                                }
                            }
                            if (request.getResponseData() == null) {
                                in = this.contextData.entrySet().iterator();
                            }
                            break block34;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (Throwable e) {
                            exception = e;
                            if (callbacks == null) {
                                callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                            }
                            processReoccurring = this.handleException(request, e, ctx, callbacks);
                            return;
                        }
                        while (in.hasNext()) {
                            Map.Entry entry = (Map.Entry)in.next();
                            ctx.setData((String)entry.getKey(), entry.getValue());
                        }
                        ctx.setData("ClassLoader", (Object)cl);
                        cmd = this.classCacheManager.findCommand(request.getCommandName(), cl);
                        results = cmd.execute(ctx);
                        if (results == null) {
                            results = new ExecutionResults();
                        }
                        try {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bout);
                            objectOutputStream.writeObject(results);
                            byte[] respData = bout.toByteArray();
                            request.setResponseData(respData);
                        }
                        catch (IOException e) {
                            request.setResponseData(null);
                        }
                        results.setData("CompletedAt", (Object)new Date());
                        request.setStatus(STATUS.DONE);
                        this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
                        processReoccurring = true;
                        break block36;
                    }
                    logger.debug("Job was already successfully executed, retrying callbacks only...");
                    byte[] resData = request.getResponseData();
                    if (resData != null) {
                        ClassLoaderObjectInputStream classLoaderObjectInputStream;
                        ObjectInputStream objectInputStream = null;
                        try {
                            classLoaderObjectInputStream = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(resData));
                            results = (ExecutionResults)classLoaderObjectInputStream.readObject();
                            if (classLoaderObjectInputStream == null) break block35;
                        }
                        catch (IOException e) {
                            logger.warn("Exception while serializing response data", (Throwable)e);
                            this.handleCompletion(processReoccurring, cmd, ctx);
                            this.eventSupport.fireAfterJobExecuted((org.kie.api.executor.RequestInfo)request, exception);
                            return;
                        }
                        classLoaderObjectInputStream.close();
                        break block35;
                        finally {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                        }
                    }
                }
                request.setStatus(STATUS.DONE);
                this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
                processReoccurring = true;
            }
            callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
            Iterator<CommandCallback> iterator = callbacks.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.handleCompletion(processReoccurring, cmd, ctx);
                    this.eventSupport.fireAfterJobExecuted((org.kie.api.executor.RequestInfo)request, exception);
                    return;
                }
                CommandCallback commandCallback = iterator.next();
                commandCallback.onCommandDone(ctx, results);
            }
            finally {
                this.handleCompletion(processReoccurring, cmd, ctx);
                this.eventSupport.fireAfterJobExecuted((org.kie.api.executor.RequestInfo)request, exception);
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error while processin executor's job {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected ClassLoader getClassLoader(String deploymentId) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (deploymentId == null) {
            return cl;
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(deploymentId);
        if (manager != null && manager.getEnvironment().getClassLoader() != null) {
            cl = manager.getEnvironment().getClassLoader();
        }
        return cl;
    }

    public void addContextData(String name, Object data) {
        this.contextData.put(name, data);
    }

    protected boolean handleException(RequestInfo request, Throwable e, CommandContext ctx, List<CommandCallback> callbacks) {
        logger.warn("Error during command {} error message {}", new Object[]{request.getCommandName(), e.getMessage(), e});
        ErrorInfo errorInfo = new ErrorInfo(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e.fillInStackTrace()));
        errorInfo.setRequestInfo(request);
        request.getErrorInfo().add(errorInfo);
        logger.debug("Error Number: {}", (Object)request.getErrorInfo().size());
        if (request.getRetries() > 0) {
            request.setStatus(STATUS.RETRYING);
            request.setRetries(request.getRetries() - 1);
            List retryDelay = (List)ctx.getData("retryDelay");
            if (retryDelay != null) {
                long retryAdd = 0L;
                try {
                    retryAdd = (Long)retryDelay.get(request.getExecutions());
                }
                catch (IndexOutOfBoundsException ex) {
                    retryAdd = (Long)retryDelay.get(retryDelay.size() - 1);
                }
                request.setTime(new Date(System.currentTimeMillis() + retryAdd));
                logger.info("Retrying request ( with id {}) - delay configured, next retry at {}", (Object)request.getId(), (Object)request.getTime());
            }
            request.setExecutions(request.getExecutions() + 1);
            logger.debug("Retrying ({}) still available!", (Object)request.getRetries());
            this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
            return false;
        }
        logger.debug("Error no retries left!");
        request.setStatus(STATUS.ERROR);
        request.setExecutions(request.getExecutions() + 1);
        this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
        if (callbacks != null) {
            for (CommandCallback handler : callbacks) {
                handler.onCommandError(ctx, e);
            }
        }
        return true;
    }

    protected void handleCompletion(boolean processReoccurring, Command cmd, CommandContext ctx) {
        if (processReoccurring && cmd != null && cmd instanceof Reoccurring) {
            Date current = new Date();
            Date nextScheduleTime = ((Reoccurring)cmd).getScheduleTime();
            if (nextScheduleTime != null && nextScheduleTime.after(current)) {
                String businessKey = (String)ctx.getData("businessKey");
                RequestInfo requestInfo = new RequestInfo();
                requestInfo.setCommandName(cmd.getClass().getName());
                requestInfo.setKey(businessKey);
                requestInfo.setStatus(STATUS.QUEUED);
                requestInfo.setTime(nextScheduleTime);
                requestInfo.setMessage("Rescheduled reoccurring job");
                requestInfo.setDeploymentId((String)ctx.getData("deploymentId"));
                requestInfo.setOwner((String)ctx.getData("owner"));
                if (ctx.getData("retries") != null) {
                    requestInfo.setRetries(Integer.valueOf(String.valueOf(ctx.getData("retries"))));
                } else {
                    requestInfo.setRetries(this.retries);
                }
                if (ctx != null) {
                    try {
                        ctx.getData().remove("ClassLoader");
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ObjectOutputStream oout = new ObjectOutputStream(bout);
                        oout.writeObject(ctx);
                        requestInfo.setRequestData(bout.toByteArray());
                    }
                    catch (IOException e) {
                        logger.warn("Error serializing context data", (Throwable)e);
                        requestInfo.setRequestData(null);
                    }
                }
                this.executorStoreService.persistRequest((org.kie.api.executor.RequestInfo)requestInfo);
            }
        }
    }
}

