/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.core.command.runtime.process.SetProcessInstanceVariablesCommand;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.commands.error.JobAutoAckErrorCommand;
import org.jbpm.executor.commands.error.ProcessAutoAckErrorCommand;
import org.jbpm.executor.commands.error.TaskAutoAckErrorCommand;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.executor.objects.IncrementService;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.process.core.async.AsyncExecutionMarker;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.exception.TaskExecutionException;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorManager;
import org.kie.internal.runtime.error.ExecutionErrorStorage;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.SecurityManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.EventService;

public class AsyncWorkItemHandlerTest
extends AbstractExecutorBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;
    private EntityManagerFactory emfErrors = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
        this.emfErrors = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.complete");
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.emfErrors != null) {
            this.emfErrors.close();
        }
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandler() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Thread.sleep(3000L);
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerWithAbort() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithParams.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("delayAsync", "5s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", parameters);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerDuplicatedRegister() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.close();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerDelayed() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithParams.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delayAsync", "4s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerAndReturnNullCommand() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.test.ReturnNullCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test
    public void testRunProcessWithAsyncHandlerWithBusinessKey() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithBusinessKey.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        String businessKey = UUID.randomUUID().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", businessKey);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        Thread.sleep(3000L);
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List jobRequest = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)jobRequest);
        Assert.assertEquals((long)1L, (long)jobRequest.size());
        Assert.assertEquals((Object)businessKey, (Object)((RequestInfo)jobRequest.get(0)).getKey());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)jobRequest.get(0)).getStatus());
    }

    @Test
    public void testRunProcessWithAsyncHandlerWithBusinessKeyAbort() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithBusinessKey.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        String businessKey = UUID.randomUUID().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", businessKey);
        params.put("delay", "5s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        runtime.getKieSession().abortProcessInstance(processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List jobRequest = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)jobRequest);
        Assert.assertEquals((long)1L, (long)jobRequest.size());
        Assert.assertEquals((Object)businessKey, (Object)((RequestInfo)jobRequest.get(0)).getKey());
        Assert.assertEquals((Object)STATUS.CANCELLED, (Object)((RequestInfo)jobRequest.get(0)).getStatus());
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerProritizedJobs() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-PrioritizedAsyncTasks.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("async-examples.priority-jobs");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List delayedPrintOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        List printOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", new QueryContext());
        Assert.assertEquals((long)1L, (long)delayedPrintOuts.size());
        Assert.assertEquals((long)1L, (long)printOuts.size());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)delayedPrintOuts.get(0)).getStatus());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)printOuts.get(0)).getStatus());
        countDownListener.waitTillCompleted();
        delayedPrintOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        printOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", new QueryContext());
        Assert.assertEquals((long)1L, (long)delayedPrintOuts.size());
        Assert.assertEquals((long)1L, (long)printOuts.size());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)delayedPrintOuts.get(0)).getStatus());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)printOuts.get(0)).getStatus());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        delayedPrintOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        printOuts = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", new QueryContext());
        Assert.assertEquals((long)1L, (long)delayedPrintOuts.size());
        Assert.assertEquals((long)1L, (long)printOuts.size());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)delayedPrintOuts.get(0)).getStatus());
        Assert.assertEquals((Object)STATUS.DONE, (Object)((RequestInfo)printOuts.get(0)).getStatus());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerCallbackErrorRetry() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithError.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)0L, (long)IncrementService.get());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("retryAsync", "1s, 2s, 4s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted(2000L);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("x", "should be fixed now");
        ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstance.getId(), variables));
        countDownListener.waitTillCompleted();
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)IncrementService.get());
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerWthSecurityManager() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        final AtomicBoolean active = new AtomicBoolean(false);
        ((InternalRuntimeManager)this.manager).setSecurityManager(new SecurityManager(){

            public void checkPermission() throws SecurityException {
                if (active.get() && !AsyncExecutionMarker.isAsync()) {
                    throw new SecurityException("Only async allowed");
                }
            }
        });
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        this.manager.disposeRuntimeEngine(runtime);
        active.set(true);
        countDownListener.waitTillCompleted();
        active.set(false);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test(timeout=20000L)
    public void testRunProcessWithAsyncHandlerCallbackErrorRetryUpdateJobData() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithRetryParam.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.test.MissingDataCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("retryAsync", "1s, 2s, 3s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Long processInstanceId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted(2000L);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        List requests = this.executorService.getRequestsByProcessInstance(processInstanceId, Arrays.asList(STATUS.RETRYING), new QueryContext());
        Assert.assertEquals((long)1L, (long)requests.size());
        Long requestId = ((RequestInfo)requests.get(0)).getId();
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("amount", 200);
        this.executorService.updateRequestData(requestId, variables);
        countDownListener.waitTillCompleted();
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        requests = this.executorService.getRequestsByProcessInstance(processInstanceId, Arrays.asList(STATUS.DONE), new QueryContext());
        Assert.assertEquals((long)1L, (long)requests.size());
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerRecordExecutionError() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        ((ExecutorServiceImpl)this.executorService).setRetries(0);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.ThrowExceptionCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        List errorJobs = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)errorJobs.size());
        RequestInfo errorJob = (RequestInfo)errorJobs.get(0);
        Assert.assertEquals((long)errorJob.getProcessInstanceId(), (long)processInstance.getId());
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        Assert.assertNotNull((String)"ErrorManager is null", (Object)errorManager);
        ExecutionErrorStorage errorStorage = errorManager.getStorage();
        Assert.assertNotNull((String)"ErrorStorage is null", (Object)errorStorage);
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        ExecutionError error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"Job", (Object)error.getType());
        Assert.assertEquals((Object)errorJob.getId(), (Object)error.getJobId());
        Assert.assertEquals((Object)"ScriptTask", (Object)error.getProcessId());
        Assert.assertEquals((Object)"", (Object)error.getActivityName());
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)error.getDeploymentId());
        Assert.assertNotNull((Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorMessage());
        Assert.assertNotNull((Object)error.getActivityId());
        Assert.assertNotNull((Object)error.getProcessInstanceId());
        Assert.assertNull((Object)error.getAcknowledgedAt());
        Assert.assertNull((Object)error.getAcknowledgedBy());
        Assert.assertFalse((boolean)error.isAcknowledged());
    }

    @Test(timeout=10000L)
    public void testRunProcessWithAsyncHandlerSkipExecutionError() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Handling error", 1);
        ((ExecutorServiceImpl)this.executorService).setRetries(0);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskErrorHandling.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.ThrowExceptionCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("command", "org.jbpm.executor.ThrowExceptionCommand");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        List errorJobs = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)errorJobs.size());
        RequestInfo errorJob = (RequestInfo)errorJobs.get(0);
        Assert.assertEquals((long)errorJob.getProcessInstanceId(), (long)processInstance.getId());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        Assert.assertNotNull((String)"ErrorManager is null", (Object)errorManager);
        ExecutionErrorStorage errorStorage = errorManager.getStorage();
        Assert.assertNotNull((String)"ErrorStorage is null", (Object)errorStorage);
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    @Test(timeout=20000L)
    public void testRunProcessWithAsyncHandlerRecordExecutionErrorAutoAck() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        ((ExecutorServiceImpl)this.executorService).setRetries(0);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.ThrowExceptionCommand"));
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        List errorJobs = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)errorJobs.size());
        RequestInfo errorJob = (RequestInfo)errorJobs.get(0);
        Assert.assertEquals((long)errorJob.getProcessInstanceId(), (long)processInstance.getId());
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        Assert.assertNotNull((String)"ErrorManager is null", (Object)errorManager);
        ExecutionErrorStorage errorStorage = errorManager.getStorage();
        Assert.assertNotNull((String)"ErrorStorage is null", (Object)errorStorage);
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        ExecutionError error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"Job", (Object)error.getType());
        Assert.assertEquals((Object)errorJob.getId(), (Object)error.getJobId());
        Assert.assertEquals((Object)"ScriptTask", (Object)error.getProcessId());
        Assert.assertEquals((Object)"", (Object)error.getActivityName());
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)error.getDeploymentId());
        Assert.assertNotNull((Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorMessage());
        Assert.assertNotNull((Object)error.getActivityId());
        Assert.assertNotNull((Object)error.getProcessInstanceId());
        Assert.assertNull((Object)error.getAcknowledgedAt());
        Assert.assertNull((Object)error.getAcknowledgedBy());
        Assert.assertFalse((boolean)error.isAcknowledged());
        countDownListener.reset(1);
        CommandContext ctx = new CommandContext();
        ctx.setData("SingleRun", (Object)"true");
        ctx.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        this.executorService.scheduleRequest(JobAutoAckErrorCommand.class.getName(), ctx);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertFalse((boolean)error.isAcknowledged());
        this.executorService.cancelRequest(errorJob.getId());
        countDownListener.reset(1);
        this.executorService.scheduleRequest(JobAutoAckErrorCommand.class.getName(), ctx);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.isAcknowledged());
    }

    @Test(timeout=20000L)
    public void testRunProcessWithAsyncHandlerRecordExecutionErrorProcessAutoAck() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        ((ExecutorServiceImpl)this.executorService).setRetries(0);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithRollback.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTaskWithRollback");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("output1", "rollback");
        try {
            taskService.complete(taskId, "john", results);
            Assert.fail((String)"Complete task should fail due to broken script");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        Assert.assertNotNull((String)"ErrorManager is null", (Object)errorManager);
        ExecutionErrorStorage errorStorage = errorManager.getStorage();
        Assert.assertNotNull((String)"ErrorStorage is null", (Object)errorStorage);
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        ExecutionError error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"Process", (Object)error.getType());
        Assert.assertEquals((Object)"UserTaskWithRollback", (Object)error.getProcessId());
        Assert.assertEquals((Object)"Script Task 1", (Object)error.getActivityName());
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)error.getDeploymentId());
        Assert.assertNotNull((Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorMessage());
        Assert.assertNotNull((Object)error.getActivityId());
        Assert.assertNotNull((Object)error.getProcessInstanceId());
        Assert.assertNull((Object)error.getAcknowledgedAt());
        Assert.assertNull((Object)error.getAcknowledgedBy());
        Assert.assertFalse((boolean)error.isAcknowledged());
        countDownListener.reset(1);
        CommandContext ctx = new CommandContext();
        ctx.setData("SingleRun", (Object)"true");
        ctx.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        this.executorService.scheduleRequest(ProcessAutoAckErrorCommand.class.getName(), ctx);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertFalse((boolean)error.isAcknowledged());
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        results = new HashMap();
        results.put("output1", "ok");
        taskService.complete(taskId, "john", results);
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.reset(1);
        this.executorService.scheduleRequest(ProcessAutoAckErrorCommand.class.getName(), ctx);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.isAcknowledged());
    }

    @Test(timeout=20000L)
    public void testRunProcessWithAsyncHandlerRecordExecutionErrorTaskAutoAck() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        ((ExecutorServiceImpl)this.executorService).setRetries(0);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithRollback.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTaskWithRollback");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        DefaultTaskEventListener listener = new DefaultTaskEventListener(){

            public void afterTaskStartedEvent(TaskEvent event) {
                throw new TaskExecutionException("On purpose");
            }
        };
        try {
            ((EventService)taskService).registerTaskEventListener((Object)listener);
            taskService.start(taskId, "john");
            Assert.fail((String)"Start task should fail due to broken script");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        Assert.assertNotNull((String)"ErrorManager is null", (Object)errorManager);
        ExecutionErrorStorage errorStorage = errorManager.getStorage();
        Assert.assertNotNull((String)"ErrorStorage is null", (Object)errorStorage);
        List errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        ExecutionError error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"Task", (Object)error.getType());
        Assert.assertEquals((Object)"UserTaskWithRollback", (Object)error.getProcessId());
        Assert.assertEquals((Object)"Hello", (Object)error.getActivityName());
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)error.getDeploymentId());
        Assert.assertNotNull((Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorMessage());
        Assert.assertNotNull((Object)error.getActivityId());
        Assert.assertNotNull((Object)error.getProcessInstanceId());
        Assert.assertNull((Object)error.getAcknowledgedAt());
        Assert.assertNull((Object)error.getAcknowledgedBy());
        Assert.assertFalse((boolean)error.isAcknowledged());
        countDownListener.reset(1);
        CommandContext ctx = new CommandContext();
        ctx.setData("SingleRun", (Object)"true");
        ctx.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        this.executorService.scheduleRequest(TaskAutoAckErrorCommand.class.getName(), ctx);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertFalse((boolean)error.isAcknowledged());
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        ((EventService)taskService).removeTaskEventListener((Object)listener);
        taskService.start(taskId, "john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("output1", "ok");
        taskService.complete(taskId, "john", results);
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.reset(1);
        this.executorService.scheduleRequest(TaskAutoAckErrorCommand.class.getName(), ctx);
        countDownListener.waitTillCompleted();
        errors = errorStorage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)errors.size());
        error = (ExecutionError)errors.get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.isAcknowledged());
    }

    private ExecutorService buildExecutorService() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        return this.executorService;
    }
}

