/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationReport;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class MigrationAsyncWorkItemHandlerTest
extends AbstractExecutorBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private RuntimeManager manager2;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;
    private EntityManagerFactory emfErrors = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
        this.emfErrors = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.complete");
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.manager2 != null) {
            RuntimeManagerRegistry.get().remove(this.manager2.getIdentifier());
            this.manager2.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.emfErrors != null) {
            this.emfErrors.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test(timeout=10000L)
    public void testMigrateProcessWithAsyncHandler() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("KieDeploymentDescriptor", (Object)new DeploymentDescriptorManager("org.jbpm.persistence.complete").getDefaultDescriptor()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(MigrationAsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.test.MissingDataCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        RuntimeEnvironment environment2 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("KieDeploymentDescriptor", (Object)new DeploymentDescriptorManager("org.jbpm.persistence.complete").getDefaultDescriptor()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(MigrationAsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.test.MissingDataCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "version1");
        Assert.assertNotNull((Object)this.manager);
        this.manager2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, "version2");
        Assert.assertNotNull((Object)this.manager2);
        CountDownAsyncJobListener countDownExecutorListener = this.configureListener(1);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        this.manager.disposeRuntimeEngine(runtime);
        countDownExecutorListener.waitTillCompleted();
        MigrationSpec migrationSpec = new MigrationSpec(this.manager.getIdentifier(), Long.valueOf(processInstance.getId()), this.manager2.getIdentifier(), "ScriptTask");
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        List executedRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((Object)this.manager2.getIdentifier(), (Object)((RequestInfo)executedRequests.get(0)).getDeploymentId());
        HashMap<String, Integer> fixedData = new HashMap<String, Integer>();
        fixedData.put("amount", 200);
        this.executorService.updateRequestData(((RequestInfo)executedRequests.get(0)).getId(), fixedData);
        countDownExecutorListener.reset(1);
        ((RequeueAware)this.executorService).requeueById(((RequestInfo)executedRequests.get(0)).getId());
        countDownExecutorListener.waitTillCompleted();
        runtime = this.manager2.getRuntimeEngine(EmptyContext.get());
        AuditService auditService = runtime.getAuditService();
        ProcessInstanceLog log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertEquals((Object)this.manager2.getIdentifier(), (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
        auditService.dispose();
        ksession = runtime.getKieSession();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager2.disposeRuntimeEngine(runtime);
    }

    @Test(timeout=10000L)
    public void testMigrateProcessWithAsyncHandlerNotAllowed() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithParams.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("KieDeploymentDescriptor", (Object)new DeploymentDescriptorManager("org.jbpm.persistence.complete").getDefaultDescriptor()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(MigrationAsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        RuntimeEnvironment environment2 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTaskWithParams.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("KieDeploymentDescriptor", (Object)new DeploymentDescriptorManager("org.jbpm.persistence.complete").getDefaultDescriptor()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(MigrationAsyncWorkItemHandlerTest.this.executorService, "org.jbpm.executor.commands.PrintOutCommand"));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "version1");
        Assert.assertNotNull((Object)this.manager);
        this.manager2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, "version2");
        Assert.assertNotNull((Object)this.manager2);
        CountDownAsyncJobListener countDownExecutorListener = this.configureListener(1);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delayAsync", "5s");
        ProcessInstance processInstance = ksession.startProcess("ScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        this.manager.disposeRuntimeEngine(runtime);
        MigrationReport report = null;
        try {
            MigrationSpec migrationSpec = new MigrationSpec(this.manager.getIdentifier(), Long.valueOf(processInstance.getId()), this.manager2.getIdentifier(), "ScriptTask");
            MigrationManager migrationManager = new MigrationManager(migrationSpec);
            migrationManager.migrate();
            Assert.fail((String)"Migration should not be allowed for active jobs");
        }
        catch (MigrationException e) {
            report = e.getReport();
            Assert.assertEquals((Object)("There are active async jobs for process instance " + processInstance.getId() + " migration not allowed with active jobs"), (Object)e.getMessage());
        }
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isSuccessful());
        countDownExecutorListener.waitTillCompleted();
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        AuditService auditService = runtime.getAuditService();
        ProcessInstanceLog log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
        auditService.dispose();
        ksession = runtime.getKieSession();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(runtime);
    }

    private ExecutorService buildExecutorService() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setRetries(0);
        this.executorService.init();
        return this.executorService;
    }
}

