/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

@RunWith(value=Parameterized.class)
public class ErrorHandlingTest
extends AbstractExecutorBaseTest {
    private PoolingDataSourceWrapper pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;
    private String asyncMode;

    @Parameterized.Parameters(name="AsyncMode : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"true"}, {"false"});
    }

    public ErrorHandlingTest(String asyncMode) {
        this.asyncMode = asyncMode;
    }

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithScriptTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Catch exception", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"ErrorHandlerOfFailingScript.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)this.asyncMode).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("exceptionType", "uncheckedException");
        parameters.put("executeAct3", true);
        ProcessInstance processInstance = ksession.startProcess("SCRA_process", parameters);
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        this.waitForAllJobsToComplete();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Set uniqueNodeNames = logs.stream().map(l -> l.getNodeName()).collect(Collectors.toSet());
        Assert.assertFalse((String)"Node 'Path Alternative' shouldn't be invoked", (boolean)uniqueNodeNames.contains("Path Alternative"));
    }

    private boolean waitForAllJobsToComplete() throws Exception {
        int attempts = 10;
        do {
            List running = this.executorService.getRunningRequests(new QueryContext());
            --attempts;
            if (running.isEmpty()) {
                return true;
            }
            Thread.sleep(500L);
        } while (attempts > 0);
        return false;
    }

    private ExecutorService buildExecutorService() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        return this.executorService;
    }
}

