/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.CountDownProcessEventListener;
import org.jbpm.test.util.ExecutorTestUtil;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncContinuationSupportTest
extends AbstractExecutorBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AsyncContinuationSupportTest.class);
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;
    private long delay = 1000L;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testAsyncScriptTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
    }

    @Test
    public void testNoAsyncServiceAvailableScriptTask() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncServiceTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncServiceProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                handlers.put("Service Task", new ServiceTaskHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        ProcessInstance processInstance = ksession.startProcess("AsyncServiceProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)6L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncMIUserTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1, true);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-MultiInstanceLoopCharacteristicsTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ArrayList<String> items = new ArrayList<String>();
        items.add("one");
        items.add("two");
        items.add("three");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("list", items);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)12L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncMISubProcess() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ArrayList<String> items = new ArrayList<String>();
        items.add("one");
        items.add("two");
        items.add("three");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("list", items);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)26L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncSubProcess() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncSubProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("AsyncSubProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testSubProcessWithAsyncNodes() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessAsyncNodes.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("SubProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset("Hello2", 1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset("Hello3", 1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        Thread.sleep(this.delay);
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testSubProcessWithSomeAsyncNodes() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello2", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessSomeAsyncNodes.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("SubProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset("Goodbye", 1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncCallActivityTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("CallActivity", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)6L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncAndSyncServiceTasks() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Async Service", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncServiceTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                handlers.put("Service Task", new ServiceTaskHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "john");
        ProcessInstance processInstance = ksession.startProcess("async-cont.async-service-task", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)14L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncScriptTaskIgnoreNotExistingDeployments() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "special-test-case");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        this.manager.close();
        List queued = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertNotNull((Object)queued);
        Assert.assertEquals((long)1L, (long)queued.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), (Object)((RequestInfo)queued.get(0)).getCommandName());
        countDownListener.waitTillCompleted(2000L);
        queued = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertNotNull((Object)queued);
        Assert.assertEquals((long)1L, (long)queued.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), (Object)((RequestInfo)queued.get(0)).getCommandName());
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "special-test-case");
        Assert.assertNotNull((Object)this.manager);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithScriptTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithAsyncScriptTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithServiceTask() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ServiceProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Service Task", new ServiceTaskHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ServiceProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)6L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)2L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithSubProcess() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)7L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithSignalProcess() throws Exception {
        final CountDownProcessEventListener countDownListenerSignalAsync = new CountDownProcessEventListener("Signal", 1, true);
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-WaitForEvent.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                listeners.add(countDownListenerSignalAsync);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("WaitForEvent");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListenerSignalAsync.waitTillCompleted();
        System.out.println("<<<< Sending signal >>>>>");
        runtime.getKieSession().signalEvent("MySignal", null);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        List all = this.executorService.getAllRequests(new QueryContext());
        logger.info("all jobs from db {}", (Object)all);
        Assert.assertEquals((long)3L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncParallelGateway() throws Exception {
        final CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("REST", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncParallelGateway.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Rest", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("TestProject.DemoProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    private boolean waitForAllJobsToComplete() throws Exception {
        int attempts = 10;
        do {
            List running = this.executorService.getRunningRequests(new QueryContext());
            --attempts;
            if (running.isEmpty()) {
                return true;
            }
            Thread.sleep(500L);
        } while (attempts > 0);
        return false;
    }

    private ExecutorService buildExecutorService() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setInterval((int)this.delay);
        this.executorService.setTimeunit(TimeUnit.MILLISECONDS);
        this.executorService.init();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.executorService;
    }
}

