/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.RequestInfoLogDeleteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicExecutorBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(BasicExecutorBaseTest.class);
    private static final long EXTRA_TIME = 2000L;
    protected ExecutorService executorService;
    public static final Map<String, Object> cachedEntities = new HashMap<String, Object>();
    protected EntityManagerFactory emf = null;

    @Before
    public void setUp() {
        this.executorService.setThreadPoolSize(1);
        this.executorService.setInterval(3);
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test(timeout=10000L)
    public void simpleExecutionTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)1L, (long)((org.kie.api.executor.RequestInfo)executedRequests.get(0)).getExecutions());
    }

    @Test(timeout=10000L)
    public void callbackTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", commandContext);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)2L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
    }

    @Test(timeout=10000L)
    public void addAnotherCallbackTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.test.AddAnotherCallbackCommand", commandContext);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)3L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
    }

    @Test(timeout=10000L)
    public void multipleCallbackTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback, org.jbpm.executor.test.CustomCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", commandContext);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)3L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
    }

    @Test(timeout=10000L)
    public void executorExceptionTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback");
        commandContext.setData("retries", (Object)0);
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", commandContext);
        logger.info("{} Sleeping for 10 secs", (Object)System.currentTimeMillis());
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        logger.info("Error: {}", inErrorRequests.get(0));
        Assert.assertEquals((long)1L, (long)((org.kie.api.executor.RequestInfo)inErrorRequests.get(0)).getExecutions());
        List errors = this.executorService.getAllErrors(new QueryContext());
        logger.info("Errors: {}", (Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test(timeout=10000L)
    public void defaultRequestRetryTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(4);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        org.kie.api.executor.RequestInfo failedJob = (org.kie.api.executor.RequestInfo)inErrorRequests.get(0);
        Assert.assertEquals((long)4L, (long)failedJob.getExecutions());
        List errors = this.executorService.getAllErrors(new QueryContext());
        logger.info("Errors: {}", (Object)errors);
        Assert.assertEquals((long)4L, (long)errors.size());
    }

    @Test(timeout=10000L)
    public void cancelRequestTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)requests);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)requestId, (Object)((org.kie.api.executor.RequestInfo)requests.get(0)).getId());
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    @Test(timeout=10000L)
    public void executorExceptionTrimmingTest() throws InterruptedException {
        System.setProperty("org.kie.executor.msg.length", "10");
        System.setProperty("org.kie.executor.stacktrace.length", "20");
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback");
        commandContext.setData("retries", (Object)0);
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", commandContext);
        logger.info("{} Sleeping for 10 secs", (Object)System.currentTimeMillis());
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        logger.info("Error: {}", inErrorRequests.get(0));
        List errors = this.executorService.getAllErrors(new QueryContext());
        logger.info("Errors: {}", (Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        ErrorInfo error = (ErrorInfo)errors.get(0);
        Assert.assertEquals((long)10L, (long)error.getMessage().length());
        Assert.assertEquals((long)20L, (long)error.getStacktrace().length());
    }

    @Test(timeout=10000L)
    public void reoccurringExecutionTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(3);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((long)1L, (long)rescheduled.size());
        this.executorService.cancelRequest(((org.kie.api.executor.RequestInfo)rescheduled.get(0)).getId());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    public void cleanupLogExecutionTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(3);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)executedRequests.size());
        this.executorService.cancelRequest(Long.valueOf(requestId + 3L));
        List canceled = this.executorService.getCancelledRequests(new QueryContext());
        ExecutorJPAAuditService auditService = new ExecutorJPAAuditService(this.emf);
        int resultCount = ((RequestInfoLogDeleteBuilder)auditService.requestInfoLogDeleteBuilder().date(new Date[]{((org.kie.api.executor.RequestInfo)canceled.get(0)).getTime()})).status(new STATUS[]{STATUS.ERROR}).build().execute();
        Assert.assertEquals((long)0L, (long)resultCount);
        resultCount = ((ErrorInfoDeleteBuilder)auditService.errorInfoLogDeleteBuilder().date(new Date[]{((org.kie.api.executor.RequestInfo)canceled.get(0)).getTime()})).build().execute();
        Assert.assertEquals((long)0L, (long)resultCount);
        ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("SingleRun", (Object)"true");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.executor");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    public void testCustomConstantRequestRetry() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(3);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("retryDelay", (Object)"2s");
        ctxCMD.setData("retries", (Object)2);
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        org.kie.api.executor.RequestInfo failedJob = (org.kie.api.executor.RequestInfo)inErrorRequests.get(0);
        Assert.assertEquals((long)3L, (long)failedJob.getExecutions());
        List errors = this.executorService.getAllErrors(new QueryContext());
        Assert.assertEquals((long)3L, (long)errors.size());
        long firstError = ((ErrorInfo)errors.get(0)).getTime().getTime();
        long secondError = ((ErrorInfo)errors.get(1)).getTime().getTime();
        long thirdError = ((ErrorInfo)errors.get(2)).getTime().getTime();
        long diff = secondError - firstError;
        Assert.assertTrue((diff > 2000L ? 1 : 0) != 0);
        diff = thirdError - secondError;
        Assert.assertTrue((diff > 2000L ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testCustomIncrementingRequestRetry() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(3);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("retryDelay", (Object)"3s, 6s");
        ctxCMD.setData("retries", (Object)2);
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        List errors = this.executorService.getAllErrors(new QueryContext());
        Assert.assertEquals((long)3L, (long)errors.size());
        long firstError = ((ErrorInfo)errors.get(0)).getTime().getTime();
        long secondError = ((ErrorInfo)errors.get(1)).getTime().getTime();
        long thirdError = ((ErrorInfo)errors.get(2)).getTime().getTime();
        long diff = secondError - firstError;
        Assert.assertTrue((diff > 3000L ? 1 : 0) != 0);
        diff = thirdError - secondError;
        Assert.assertTrue((diff > 6000L ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testCustomIncrementingRequestRetrySpecialValues() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(2);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("retryDelay", (Object)"-1ms, 1m 80s");
        ctxCMD.setData("retries", (Object)2);
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List errors = this.executorService.getAllErrors(new QueryContext());
        Assert.assertEquals((long)2L, (long)errors.size());
        long firstError = ((ErrorInfo)errors.get(0)).getTime().getTime();
        long secondError = ((ErrorInfo)errors.get(1)).getTime().getTime();
        long diff = secondError - firstError;
        Assert.assertTrue((diff < 4000L ? 1 : 0) != 0);
        List allRequests = this.executorService.getAllRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)allRequests.size());
        diff = ((org.kie.api.executor.RequestInfo)allRequests.get(0)).getTime().getTime() - Calendar.getInstance().getTimeInMillis();
        Assert.assertTrue((diff <= 140000L ? 1 : 0) != 0);
        Assert.assertTrue((diff > 130000L ? 1 : 0) != 0);
        this.executorService.clearAllRequests();
    }

    @Test(timeout=10000L)
    public void cancelRequestWithSearchByCommandTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.test.CustomCommand", futureDate, ctxCMD);
        List requests = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        Assert.assertNotNull((Object)requests);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)requestId, (Object)((org.kie.api.executor.RequestInfo)requests.get(0)).getId());
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    @Test(timeout=10000L)
    public void executorPagingTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        Long requestId1 = this.executorService.scheduleRequest("org.jbpm.executor.test.CustomCommand", futureDate, ctxCMD);
        Long requestId2 = this.executorService.scheduleRequest("org.jbpm.executor.test.CustomCommand", futureDate, ctxCMD);
        QueryContext queryContextFirstPage = new QueryContext(Integer.valueOf(0), Integer.valueOf(1));
        QueryContext queryContextSecondPage = new QueryContext(Integer.valueOf(1), Integer.valueOf(1));
        List firstRequests = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", queryContextFirstPage);
        List secondRequests = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", queryContextSecondPage);
        this.compareRequestsAreNotSame((org.kie.api.executor.RequestInfo)firstRequests.get(0), (org.kie.api.executor.RequestInfo)secondRequests.get(0));
        firstRequests = this.executorService.getRequestsByBusinessKey(businessKey, queryContextFirstPage);
        secondRequests = this.executorService.getRequestsByBusinessKey(businessKey, queryContextSecondPage);
        this.compareRequestsAreNotSame((org.kie.api.executor.RequestInfo)firstRequests.get(0), (org.kie.api.executor.RequestInfo)secondRequests.get(0));
        firstRequests = this.executorService.getQueuedRequests(queryContextFirstPage);
        secondRequests = this.executorService.getQueuedRequests(queryContextSecondPage);
        this.compareRequestsAreNotSame((org.kie.api.executor.RequestInfo)firstRequests.get(0), (org.kie.api.executor.RequestInfo)secondRequests.get(0));
        this.executorService.cancelRequest(requestId1);
        this.executorService.cancelRequest(requestId2);
        firstRequests = this.executorService.getCancelledRequests(queryContextFirstPage);
        secondRequests = this.executorService.getCancelledRequests(queryContextSecondPage);
        this.compareRequestsAreNotSame((org.kie.api.executor.RequestInfo)firstRequests.get(0), (org.kie.api.executor.RequestInfo)secondRequests.get(0));
        firstRequests = this.executorService.getAllRequests(queryContextFirstPage);
        secondRequests = this.executorService.getAllRequests(queryContextSecondPage);
        this.compareRequestsAreNotSame((org.kie.api.executor.RequestInfo)firstRequests.get(0), (org.kie.api.executor.RequestInfo)secondRequests.get(0));
        QueryContext queryContextBigOffset = new QueryContext(Integer.valueOf(10), Integer.valueOf(1));
        List offsetRequests = this.executorService.getCancelledRequests(queryContextBigOffset);
        Assert.assertNotNull((Object)offsetRequests);
        Assert.assertEquals((long)0L, (long)offsetRequests.size());
    }

    @Test(timeout=10000L)
    public void clearAllRequestsTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.test.CustomCommand", futureDate, ctxCMD);
        List allRequests = this.executorService.getAllRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)allRequests.size());
        this.executorService.clearAllRequests();
        allRequests = this.executorService.getAllRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)allRequests.size());
        requestId = this.executorService.scheduleRequest("org.jbpm.executor.test.CustomCommand", futureDate, ctxCMD);
        allRequests = this.executorService.getAllRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)allRequests.size());
        this.executorService.cancelRequest(requestId);
        this.executorService.clearAllRequests();
        allRequests = this.executorService.getAllRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)allRequests.size());
    }

    @Test(timeout=10000L)
    public void testReturnNullCommand() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.test.ReturnNullCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    public void testPrioritizedJobsExecution() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(2);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)"low priority");
        ctxCMD.setData("priority", (Object)2);
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD);
        CommandContext ctxCMD2 = new CommandContext();
        ctxCMD2.setData("businessKey", (Object)"high priority");
        ctxCMD2.setData("priority", (Object)8);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD2);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)2L, (long)executedRequests.size());
        org.kie.api.executor.RequestInfo executedHigh = (org.kie.api.executor.RequestInfo)executedRequests.get(1);
        Assert.assertNotNull((Object)executedHigh);
        Assert.assertEquals((Object)"high priority", (Object)executedHigh.getKey());
        org.kie.api.executor.RequestInfo executedLow = (org.kie.api.executor.RequestInfo)executedRequests.get(0);
        Assert.assertNotNull((Object)executedLow);
        Assert.assertEquals((Object)"low priority", (Object)executedLow.getKey());
        Assert.assertTrue((executedLow.getTime().getTime() >= executedHigh.getTime().getTime() ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testPrioritizedJobsExecutionInvalidProrities() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(2);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)"low priority");
        ctxCMD.setData("priority", (Object)-1);
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD);
        CommandContext ctxCMD2 = new CommandContext();
        ctxCMD2.setData("businessKey", (Object)"high priority");
        ctxCMD2.setData("priority", (Object)10);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD2);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)2L, (long)executedRequests.size());
        org.kie.api.executor.RequestInfo executedHigh = (org.kie.api.executor.RequestInfo)executedRequests.get(1);
        Assert.assertNotNull((Object)executedHigh);
        Assert.assertEquals((Object)"high priority", (Object)executedHigh.getKey());
        org.kie.api.executor.RequestInfo executedLow = (org.kie.api.executor.RequestInfo)executedRequests.get(0);
        Assert.assertNotNull((Object)executedLow);
        Assert.assertEquals((Object)"low priority", (Object)executedLow.getKey());
        Assert.assertTrue((executedLow.getTime().getTime() >= executedHigh.getTime().getTime() ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testProcessContextJobsExecution() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)"low priority");
        ctxCMD.setData("deploymentId", (Object)"not-deployed-here");
        ctxCMD.setData("processInstanceId", (Object)2L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        List<STATUS> statuses = Arrays.asList(STATUS.QUEUED);
        List byDeploymentRequests = this.executorService.getRequestsByDeployment("not-deployed-here", statuses, new QueryContext());
        Assert.assertEquals((long)1L, (long)byDeploymentRequests.size());
        List byProcessInstanceRequests = this.executorService.getRequestsByProcessInstance(Long.valueOf(2L), statuses, new QueryContext());
        Assert.assertEquals((long)1L, (long)byProcessInstanceRequests.size());
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)executedRequests.size());
        countDownListener.waitTillCompleted(5000L);
        inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)executedRequests.size());
        this.executorService.cancelRequest(requestId);
    }

    @Test(timeout=10000L)
    public void testJobsQueryWithStatus() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)"low priority");
        ctxCMD.setData("deploymentId", (Object)"not-deployed-here");
        ctxCMD.setData("processInstanceId", (Object)2L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        List<STATUS> statuses = Arrays.asList(STATUS.QUEUED);
        List byDeploymentRequests = this.executorService.getRequestsByDeployment("not-deployed-here", statuses, new QueryContext());
        Assert.assertEquals((long)1L, (long)byDeploymentRequests.size());
        List byProcessInstanceRequests = this.executorService.getRequestsByProcessInstance(Long.valueOf(2L), statuses, new QueryContext());
        Assert.assertEquals((long)1L, (long)byProcessInstanceRequests.size());
        List byKeyRequests = this.executorService.getRequestsByBusinessKey("low priority", statuses, new QueryContext());
        Assert.assertEquals((long)1L, (long)byKeyRequests.size());
        List byCommandRequests = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", statuses, new QueryContext());
        Assert.assertEquals((long)1L, (long)byCommandRequests.size());
        statuses = Arrays.asList(STATUS.DONE);
        byDeploymentRequests = this.executorService.getRequestsByDeployment("not-deployed-here", statuses, new QueryContext());
        Assert.assertEquals((long)0L, (long)byDeploymentRequests.size());
        byProcessInstanceRequests = this.executorService.getRequestsByProcessInstance(Long.valueOf(2L), statuses, new QueryContext());
        Assert.assertEquals((long)0L, (long)byProcessInstanceRequests.size());
        byKeyRequests = this.executorService.getRequestsByBusinessKey("low priority", statuses, new QueryContext());
        Assert.assertEquals((long)0L, (long)byKeyRequests.size());
        byCommandRequests = this.executorService.getRequestsByCommand("org.jbpm.executor.commands.PrintOutCommand", statuses, new QueryContext());
        Assert.assertEquals((long)0L, (long)byCommandRequests.size());
        this.executorService.cancelRequest(requestId);
    }

    @Test(timeout=10000L)
    public void testUpdateRequestData() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(2);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("retryDelay", (Object)"1s, 2s");
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.test.MissingDataCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)executedRequests.size());
        HashMap<String, Integer> fixedData = new HashMap<String, Integer>();
        fixedData.put("amount", 200);
        this.executorService.updateRequestData(requestId, fixedData);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    public void testUpdateRequestDataFromErrorState() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("retries", (Object)0);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.test.MissingDataCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        HashMap<String, Integer> fixedData = new HashMap<String, Integer>();
        fixedData.put("amount", 200);
        this.executorService.updateRequestData(requestId, fixedData);
        countDownListener.reset(1);
        ((RequeueAware)this.executorService).requeueById(requestId);
        countDownListener.waitTillCompleted();
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    public void testDeploymentIdParameter() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        ctxCMD.setData("DeploymentId", (Object)"testUpperCase");
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)requests);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)requestId, (Object)((org.kie.api.executor.RequestInfo)requests.get(0)).getId());
        Assert.assertEquals((Object)"testUpperCase", (Object)((org.kie.api.executor.RequestInfo)requests.get(0)).getDeploymentId());
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    @Test(timeout=10000L)
    public void testDeploymentIdParameterLowerCase() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        ctxCMD.setData("deploymentId", (Object)"testLowerCase");
        Date futureDate = new Date(System.currentTimeMillis() + 2000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)requests);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)requestId, (Object)((org.kie.api.executor.RequestInfo)requests.get(0)).getId());
        Assert.assertEquals((Object)"testLowerCase", (Object)((org.kie.api.executor.RequestInfo)requests.get(0)).getDeploymentId());
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    @Test(timeout=10000L)
    public void testRequeueWithSeconds() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        EntityManager em = this.emf.createEntityManager();
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setCommandName("org.jbpm.executor.commands.PrintOutCommand");
        requestInfo.setKey(businessKey);
        requestInfo.setStatus(STATUS.RUNNING);
        Date originalScheduledTime = new Date();
        requestInfo.setTime(originalScheduledTime);
        requestInfo.setMessage("Ready to execute");
        requestInfo.setDeploymentId(null);
        requestInfo.setRetries(0);
        requestInfo.setPriority(5);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(ctxCMD);
        requestInfo.setRequestData(bout.toByteArray());
        em.persist((Object)requestInfo);
        em.close();
        ut.commit();
        ((RequeueAware)this.executorService).requeue(Long.valueOf(2L));
        countDownListener.waitTillCompleted(2000L);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        org.kie.api.executor.RequestInfo requestInfoAfterFirstRequeue = (org.kie.api.executor.RequestInfo)requests.get(0);
        Assert.assertEquals((String)"The job should not be requeued yet", (Object)STATUS.RUNNING, (Object)requestInfoAfterFirstRequeue.getStatus());
        Assert.assertEquals((String)"The job should not be requeued yet", (Object)originalScheduledTime, (Object)requestInfoAfterFirstRequeue.getTime());
        ((RequeueAware)this.executorService).requeue(Long.valueOf(2L));
        countDownListener.waitTillCompleted(2000L);
        requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        org.kie.api.executor.RequestInfo requestInfoAfterSecondRequeue = (org.kie.api.executor.RequestInfo)requests.get(0);
        Assert.assertTrue((String)"The job should be requeued and executed", (requestInfoAfterSecondRequeue.getStatus() == STATUS.DONE ? 1 : 0) != 0);
    }

    private void compareRequestsAreNotSame(org.kie.api.executor.RequestInfo firstRequest, org.kie.api.executor.RequestInfo secondRequest) {
        Assert.assertNotNull((Object)firstRequest);
        Assert.assertNotNull((Object)secondRequest);
        Assert.assertNotEquals((String)"Requests are same!", (Object)firstRequest.getId(), (Object)secondRequest.getId());
    }
}

