/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class ReconfiguredExecutorTest {
    protected ExecutorService executorService;
    private static final long EXTRA_TIME = 2000L;
    private PoolingDataSourceWrapper pds;
    private EntityManagerFactory emf = null;

    @Before
    public void setUp() {
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setThreadPoolSize(2);
        this.executorService.setInterval(3000);
        this.executorService.setTimeunit(TimeUnit.MILLISECONDS);
        this.executorService.init();
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test
    public void simpleExcecutionTest() throws InterruptedException {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        countDownListener.waitTillCompleted();
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test(timeout=10000L)
    public void testRequeueWithMilliseconds() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        EntityManager em = this.emf.createEntityManager();
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setCommandName("org.jbpm.executor.commands.PrintOutCommand");
        requestInfo.setKey(businessKey);
        requestInfo.setStatus(STATUS.RUNNING);
        Date originalScheduledTime = new Date();
        requestInfo.setTime(originalScheduledTime);
        requestInfo.setMessage("Ready to execute");
        requestInfo.setDeploymentId(null);
        requestInfo.setRetries(0);
        requestInfo.setPriority(5);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(ctxCMD);
        requestInfo.setRequestData(bout.toByteArray());
        em.persist((Object)requestInfo);
        em.close();
        ut.commit();
        ((RequeueAware)this.executorService).requeue(Long.valueOf(2000L));
        countDownListener.waitTillCompleted(2000L);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        org.kie.api.executor.RequestInfo requestInfoAfterFirstRequeue = (org.kie.api.executor.RequestInfo)requests.get(0);
        Assert.assertEquals((String)"The job should not be requeued yet", (Object)STATUS.RUNNING, (Object)requestInfoAfterFirstRequeue.getStatus());
        Assert.assertEquals((String)"The job should not be requeued yet", (Object)originalScheduledTime, (Object)requestInfoAfterFirstRequeue.getTime());
        ((RequeueAware)this.executorService).requeue(Long.valueOf(2000L));
        countDownListener.waitTillCompleted(2000L);
        requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        org.kie.api.executor.RequestInfo requestInfoAfterSecondRequeue = (org.kie.api.executor.RequestInfo)requests.get(0);
        TestCase.assertTrue((String)"The job should be requeued and executed", (requestInfoAfterSecondRequeue.getStatus() == STATUS.DONE ? 1 : 0) != 0);
    }
}

