/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.commands.PrintOutCommand;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.listener.process.NodeTriggeredCountDownProcessEventListener;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncContinuationSupportTest
extends AbstractExecutorBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AsyncContinuationSupportTest.class);
    private PoolingDataSourceWrapper pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testAsyncScriptTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
    }

    @Test
    public void testNoAsyncServiceAvailableScriptTask() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        long processInstanceId = processInstance.getId();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncServiceTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncServiceProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                handlers.put("Service Task", new ServiceTaskHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        ProcessInstance processInstance = ksession.startProcess("AsyncServiceProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)6L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncMIUserTask() throws Exception {
        final NodeTriggeredCountDownProcessEventListener countDownListener = new NodeTriggeredCountDownProcessEventListener("Hello", 3);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-MultiInstanceLoopCharacteristicsTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ArrayList<String> items = new ArrayList<String>();
        items.add("one");
        items.add("two");
        items.add("three");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("list", items);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)12L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncMISubProcess() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 3);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ArrayList<String> items = new ArrayList<String>();
        items.add("one");
        items.add("two");
        items.add("three");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("list", items);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)26L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncSubProcess() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncSubProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("AsyncSubProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testSubProcessWithAsyncNodes() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessAsyncNodes.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("SubProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testSubProcessWithSomeAsyncNodes() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Goodbye", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessSomeAsyncNodes.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("SubProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncCallActivityTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("CallActivity", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)6L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncAndSyncServiceTasks() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Async Service", 3);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncServiceTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                handlers.put("Service Task", new ServiceTaskHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "john");
        ProcessInstance processInstance = ksession.startProcess("async-cont.async-service-task", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)14L, (long)logs.size());
    }

    @Test(timeout=1000000L)
    public void testAsyncScriptTaskIgnoreNotExistingDeployments() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        final NodeLeftCountDownProcessEventListener countDownListener2 = new NodeLeftCountDownProcessEventListener("Task 1", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new AsyncWorkItemHandler(AsyncContinuationSupportTest.this.executorService, PrintOutCommand.class.getName()));
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                listeners.add(countDownListener2);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "special-test-case");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delayAsync", "2s");
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted(1000L);
        this.manager.close();
        List queued = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertNotNull((Object)queued);
        Assert.assertEquals((long)1L, (long)queued.size());
        Assert.assertEquals((Object)PrintOutCommand.class.getName(), (Object)((RequestInfo)queued.get(0)).getCommandName());
        countDownListener2.waitTillCompleted(2000L);
        queued = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertNotNull((Object)queued);
        Assert.assertEquals((long)1L, (long)queued.size());
        Assert.assertEquals((Object)PrintOutCommand.class.getName(), (Object)((RequestInfo)queued.get(0)).getCommandName());
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "special-test-case");
        Assert.assertNotNull((Object)this.manager);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        countDownListener2.reset(1);
        ((RequeueAware)this.executorService).requeueById(((RequestInfo)queued.get(0)).getId());
        countDownListener2.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithScriptTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithAsyncScriptTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncScriptTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("async", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("AsyncScriptTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithServiceTask() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ServiceProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Service Task", new ServiceTaskHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("ServiceProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)6L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)2L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithSubProcess() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcess.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)18L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)7L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithSignalProcess() throws Exception {
        final NodeTriggeredCountDownProcessEventListener countDownListenerSignalAsync = new NodeTriggeredCountDownProcessEventListener("Signal", 1);
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-WaitForEvent.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                listeners.add(countDownListenerSignalAsync);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("WaitForEvent");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListenerSignalAsync.waitTillCompleted();
        System.out.println("<<<< Sending signal >>>>>");
        runtime.getKieSession().signalEvent("MySignal", null);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        List logs = runtime.getAuditService().findNodeInstances(processInstanceId);
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)8L, (long)logs.size());
        this.waitForAllJobsToComplete();
        List completed = this.executorService.getCompletedRequests(new QueryContext());
        List all = this.executorService.getAllRequests(new QueryContext());
        logger.info("all jobs from db {}", (Object)all);
        Assert.assertEquals((long)2L, (long)completed.size());
        Set commands = completed.stream().map(RequestInfo::getCommandName).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertEquals((Object)AsyncSignalEventCommand.class.getName(), commands.iterator().next());
    }

    @Test(timeout=10000L)
    public void testAsyncParallelGateway() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("REST", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncParallelGateway.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Rest", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("TestProject.DemoProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithParallelGateway() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncParallelGateway.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Rest", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("TestProject.DemoProcess");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithTimer() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryEnd", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"ProbAsync.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timer1", "2s");
        params.put("timer2", "10s");
        ProcessInstance processInstance = ksession.startProcess("ProbAsync", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithSignal() throws Exception {
        CountDownAsyncJobListener initialJob = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)initialJob);
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("SignalEnd", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"ProbAsync.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timer1", "20s");
        params.put("timer2", "10s");
        ProcessInstance processInstance = ksession.startProcess("ProbAsync", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        initialJob.waitTillCompleted();
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        runtime.getTaskService().start(taskId, "john");
        runtime.getTaskService().complete(taskId, "john", null);
        runtime.getKieSession().signalEvent("signal1", null, processInstanceId);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithSignalEventSubProcess() throws Exception {
        CountDownAsyncJobListener initialJob = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)initialJob);
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("SubprocessEnd", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"ProbAsync.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timer1", "20s");
        params.put("timer2", "10s");
        ProcessInstance processInstance = ksession.startProcess("ProbAsync", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        initialJob.waitTillCompleted();
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        runtime.getKieSession().signalEvent("startSignal", null, processInstanceId);
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
    }

    @Test(timeout=10000L)
    public void testAsyncModeWithInclusiveGateway() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("EndProcess", 1);
        final NodeTriggerCountListener triggerListener = new NodeTriggerCountListener("ScriptTask-4");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-AsyncInclusiveGateway.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("ExecutorService", (Object)this.executorService).addEnvironmentEntry("AsyncMode", (Object)"true").registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Rest", new SystemOutWorkItemHandler());
                return handlers;
            }

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                listeners.add(triggerListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Var1", "AAA");
        ProcessInstance processInstance = ksession.startProcess("TestProject.DemoProcess", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        long processInstanceId = processInstance.getId();
        countDownListener.waitTillCompleted();
        processInstance = runtime.getKieSession().getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)triggerListener.getCount().intValue());
    }

    private boolean waitForAllJobsToComplete() throws Exception {
        int attempts = 10;
        do {
            List runningOrQueued = this.executorService.getRequestsByStatus(Arrays.asList(STATUS.RUNNING, STATUS.QUEUED), new QueryContext());
            --attempts;
            if (runningOrQueued.isEmpty()) {
                return true;
            }
            Thread.sleep(500L);
        } while (attempts > 0);
        return false;
    }

    private ExecutorService buildExecutorService() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        return this.executorService;
    }

    private static class NodeTriggerCountListener
    extends DefaultProcessEventListener {
        private AtomicInteger count = new AtomicInteger(0);
        private String nodeName;

        private NodeTriggerCountListener(String nodeName) {
            this.nodeName = nodeName;
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            if (event.getNodeInstance().getNodeName().equals(this.nodeName)) {
                this.count.getAndIncrement();
            }
        }

        public AtomicInteger getCount() {
            return this.count;
        }
    }
}

