/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.impl.ExecutorImpl;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.executor.ExecutorStoreService;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class InitExecutorTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.executor.pool.size");
        System.clearProperty("org.kie.executor.initial.delay");
    }

    @Test
    public void testSingleThreadExecutor() {
        ScheduledExecutorService mockedExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ExecutorImpl executor = this.buildExecutor(mockedExecutorService);
        executor.init();
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)2100L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testSingleThreadExecutorCustomInitialDelay() {
        System.setProperty("org.kie.executor.initial.delay", "5000");
        ScheduledExecutorService mockedExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ExecutorImpl executor = this.buildExecutor(mockedExecutorService);
        executor.init();
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)7000L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testManyThreadExecutor() {
        System.setProperty("org.kie.executor.pool.size", "4");
        ScheduledExecutorService mockedExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ExecutorImpl executor = this.buildExecutor(mockedExecutorService);
        executor.init();
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)2100L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)4100L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)6100L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)8100L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testManyThreadExecutorCustomInitialDelay() {
        System.setProperty("org.kie.executor.pool.size", "4");
        System.setProperty("org.kie.executor.initial.delay", "5000");
        ScheduledExecutorService mockedExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ExecutorImpl executor = this.buildExecutor(mockedExecutorService);
        executor.init();
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)7000L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)9000L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)11000L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)mockedExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)Mockito.eq(null), Mockito.eq((long)13000L), Mockito.eq((long)3000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    protected ExecutorImpl buildExecutor(final ScheduledExecutorService mockedExecutorService) {
        ExecutorStoreService mockedExecutorStoreService = (ExecutorStoreService)Mockito.mock(ExecutorStoreService.class);
        ExecutorImpl executor = new ExecutorImpl(){

            protected ScheduledExecutorService getScheduledExecutorService() {
                return mockedExecutorService;
            }
        };
        executor.setExecutorStoreService(mockedExecutorStoreService);
        return executor;
    }
}

