/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.BasicExecutorBaseTest;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobStartedListener;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class NoCDISimpleExecutorTest
extends BasicExecutorBaseTest {
    private PoolingDataSourceWrapper pds;

    @Override
    @Before
    public void setUp() {
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        super.setUp();
    }

    @Test(timeout=10000L)
    public void testJobsQueryWithStatusAfterInterrupt() throws InterruptedException {
        CountDownAsyncJobStartedListener countDownListener = new CountDownAsyncJobStartedListener(1);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        String uuid = UUID.randomUUID().toString();
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)uuid);
        this.executorService.scheduleRequest("org.jbpm.executor.ReoccurringPrintOutCommand", ctxCMD);
        countDownListener.waitTillStarted();
        List uuidRequests = this.executorService.getRequestsByBusinessKey(uuid, new QueryContext());
        Assert.assertEquals((long)1L, (long)uuidRequests.size());
        Assert.assertEquals((Object)STATUS.RUNNING, (Object)((RequestInfo)uuidRequests.get(0)).getStatus());
        this.executorService.destroy();
        List info = this.executorService.getRequestsByBusinessKey(uuid, new QueryContext());
        Assert.assertEquals((Object)STATUS.QUEUED, (Object)((RequestInfo)info.get(0)).getStatus());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }
}

