/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedExecutorTest {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedExecutorTest.class);
    private ExecutorService executorService;
    private static Properties dsProps;
    private EntityManagerFactory emf = null;
    private PoolingDataSourceWrapper pds;

    @BeforeClass
    public static void createDBServer() {
        System.setProperty("org.kie.executor.id", "owner");
        System.setProperty("org.kie.executor.setDefaultOwner", "true");
        System.setProperty("org.kie.executor.olderThan", "2");
        dsProps = ExecutorTestUtil.getDatasourceProperties();
        dsProps.setProperty("url", "jdbc:h2:tcp://localhost:9123/./target/jbpm-exec-test;MODE=LEGACY;NON_KEYWORDS=VALUE");
        dsProps.setProperty("tcpPort", "9123");
        PersistenceUtil.startH2TcpServer((Properties)dsProps);
        ExecutorService.IdProvider.reset();
    }

    @AfterClass
    public static void stopDBServer() {
        System.clearProperty("org.kie.executor.id");
        System.clearProperty("org.kie.executor.setDefaultOwner");
        System.clearProperty("org.kie.executor.olderThan");
        PersistenceUtil.stopH2TcpServer();
        ExecutorService.IdProvider.reset();
    }

    @Before
    public void setUp() {
        this.pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)"jdbc/jbpm-ds");
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.setThreadPoolSize(1);
        this.executorService.setInterval(3);
        this.executorService.init();
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        this.executorService.destroy();
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test(timeout=60000L)
    public void testSchedulerWithOwner() throws Exception {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Date schedule = new Date(Instant.now().plus(Duration.ofSeconds(5L)).toEpochMilli());
        logger.info("schedule command for {}", (Object)schedule);
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", schedule, ctxCMD);
        List rescheduled = this.executorService.getRequestsByBusinessKey((String)ctxCMD.getData("businessKey"), Arrays.asList(STATUS.QUEUED), new QueryContext());
        Assert.assertEquals((Object)"owner", (Object)((RequestInfo)rescheduled.get(0)).getOwner());
    }

    @Test(timeout=60000L)
    public void testOlderThan() throws Exception {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        ExecutorImpl impl = (ExecutorImpl)((ExecutorServiceImpl)this.executorService).getExecutor();
        long start = System.currentTimeMillis();
        Date schedule = new Date(Instant.now().plus(Duration.ofSeconds(5L)).toEpochMilli());
        logger.info("schedule command for {}", (Object)schedule);
        impl.getExecutorStoreService().persistRequest((org.kie.api.executor.RequestInfo)impl.buildRequestInfo("org.jbpm.executor.commands.PrintOutCommand", schedule, ctxCMD), tmp -> {});
        countDownListener.waitTillCompleted();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 7000L ? 1 : 0) != 0);
    }
}

