/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.concurrent;

import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.drools.persistence.api.TransactionSynchronization;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.concurrent.PrioritisedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleTaskTransactionSynchronization
implements TransactionSynchronization {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskTransactionSynchronization.class);
    private ScheduledExecutorService scheduler;
    private RequestInfo requestInfo;
    private Date date;
    private AvailableJobsExecutor jobProcessor;

    public ScheduleTaskTransactionSynchronization(ScheduledExecutorService scheduler, RequestInfo requestInfo, Date date, AvailableJobsExecutor jobProcessor) {
        this.scheduler = scheduler;
        this.requestInfo = requestInfo;
        this.date = date;
        this.jobProcessor = jobProcessor;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (status == 0) {
            PrioritisedRunnable jobExecution = new PrioritisedRunnable(this.requestInfo.getId(), this.requestInfo.getPriority(), this.requestInfo.getTime(), this.jobProcessor);
            if (this.date == null) {
                logger.debug("Directly executing request {}", (Object)this.requestInfo.getId());
                this.scheduler.execute(jobExecution);
            } else {
                long delay = this.date.getTime() - System.currentTimeMillis();
                logger.debug("Scheduling with delay {} for request {}", (Object)delay, (Object)this.requestInfo.getId());
                this.scheduler.schedule(jobExecution, delay, TimeUnit.MILLISECONDS);
            }
        }
    }
}

