/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.query.QueryBuilderCoverageTestUtil;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.executor.STATUS;
import org.kie.internal.query.ExtendedParametrizedQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.RequestInfoQueryBuilder;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorQueryBuilderCoverageTest {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorQueryBuilderCoverageTest.class);
    private static PoolingDataSourceWrapper pds;
    private static EntityManagerFactory emf;
    private ExecutorJPAAuditService auditService;
    private static QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller inputFiller;

    @BeforeClass
    public static void configure() {
        pds = ExecutorTestUtil.setupPoolingDataSource();
        emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        QueryBuilderCoverageTestUtil.hackTheDatabaseMetadataLoggerBecauseTheresALogbackXmlInTheClasspath();
    }

    @Before
    public void setup() {
        this.auditService = new ExecutorJPAAuditService(emf);
    }

    @AfterClass
    public static void reset() {
        if (emf != null) {
            emf.close();
            emf = null;
        }
        if (pds != null) {
            pds.close();
            pds = null;
        }
    }

    @Test
    public void errorInfoQueryBuilderCoverageTest() {
        ErrorInfoQueryBuilder queryBuilder = this.auditService.errorInfoQueryBuilder();
        Class<ErrorInfoQueryBuilder> builderClass = ErrorInfoQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    @Test
    public void requestInfoQueryBuilderCoverageTest() {
        RequestInfoQueryBuilder queryBuilder = this.auditService.requestInfoQueryBuilder();
        Class<RequestInfoQueryBuilder> builderClass = RequestInfoQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    static {
        inputFiller = new QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller(){
            private int errorInfoOrderByType = 0;
            private int requestInfoOrderByType = 0;

            public Object fillInput(Class type) {
                Class<?> elemType;
                if (ErrorInfoQueryBuilder.OrderBy.class.equals((Object)type)) {
                    return this.errorInfoOrderByType++ % 2 == 0 ? ErrorInfoQueryBuilder.OrderBy.id : ErrorInfoQueryBuilder.OrderBy.time;
                }
                if (RequestInfoQueryBuilder.OrderBy.class.equals((Object)type)) {
                    switch (this.requestInfoOrderByType++ % 6) {
                        case 0: {
                            return RequestInfoQueryBuilder.OrderBy.deploymentId;
                        }
                        case 1: {
                            return RequestInfoQueryBuilder.OrderBy.executions;
                        }
                        case 2: {
                            return RequestInfoQueryBuilder.OrderBy.id;
                        }
                        case 3: {
                            return RequestInfoQueryBuilder.OrderBy.retries;
                        }
                        case 4: {
                            return RequestInfoQueryBuilder.OrderBy.status;
                        }
                        case 5: {
                            return RequestInfoQueryBuilder.OrderBy.time;
                        }
                    }
                } else if (type.isArray() && STATUS.class.equals(elemType = type.getComponentType())) {
                    STATUS[] statusArr = new STATUS[]{STATUS.DONE, STATUS.CANCELLED, STATUS.ERROR};
                    return statusArr;
                }
                return null;
            }
        };
    }
}

