/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.test.CountDownAsyncJobListener;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractExecutorBaseTest;
import org.jbpm.test.util.ExecutorTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class SLATrackingCommandTest
extends AbstractExecutorBaseTest {
    private PoolingDataSourceWrapper pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private ExecutorService executorService;
    private EntityManagerFactory emf = null;

    @Before
    public void setup() {
        ExecutorTestUtil.cleanupSingletonSessionId();
        this.pds = ExecutorTestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.executorService = this.buildExecutorService();
    }

    @After
    public void teardown() {
        this.executorService.destroy();
        if (this.manager != null) {
            RuntimeManagerRegistry.get().remove(this.manager.getIdentifier());
            this.manager.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this.pds.close();
    }

    protected CountDownAsyncJobListener configureListener(int threads) {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(threads);
        ((ExecutorServiceImpl)this.executorService).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        return countDownListener;
    }

    @Test
    public void testSLATrackingOnProcessInstance() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithSLA.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("SLATimerMode", (Object)"false").get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        JPAAuditLogService logService = new JPAAuditLogService(this.emf);
        this.assertProcessInstanceSLACompliance(logService, processInstance.getId(), 1);
        this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceSLACompliance(logService, processInstance.getId(), 1);
        Thread.sleep(3000L);
        countDownListener.reset(1);
        this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceSLACompliance(logService, processInstance.getId(), 3);
    }

    @Test
    public void testSLATrackingOnUserTask() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithSLAOnTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("SLATimerMode", (Object)"false").get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        JPAAuditLogService logService = new JPAAuditLogService(this.emf);
        this.assertNodeInstanceSLACompliance(logService, processInstance.getId(), "Hello", 1, 0);
        this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        this.assertNodeInstanceSLACompliance(logService, processInstance.getId(), "Hello", 1, 0);
        Thread.sleep(3000L);
        countDownListener.reset(1);
        this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        runtime.getTaskService().start(((TaskSummary)tasks.get(0)).getId().longValue(), "john");
        runtime.getTaskService().complete(((TaskSummary)tasks.get(0)).getId().longValue(), "john", null);
        this.assertNodeInstanceSLACompliance(logService, processInstance.getId(), "Hello", 3, 1);
    }

    @Test
    public void testSLATrackingOnProcessInstanceSLAMet() {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithSLA.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("SLATimerMode", (Object)"false").get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        JPAAuditLogService logService = new JPAAuditLogService(this.emf);
        this.assertProcessInstanceSLACompliance(logService, processInstance.getId(), 1);
        this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceSLACompliance(logService, processInstance.getId(), 1);
        runtime.getTaskService().start(((TaskSummary)tasks.get(0)).getId().longValue(), "john");
        runtime.getTaskService().complete(((TaskSummary)tasks.get(0)).getId().longValue(), "john", null);
        this.assertProcessInstanceSLACompliance(logService, processInstance.getId(), 2);
    }

    @Test
    public void testSLATrackingOnUserTaskSLAMet() {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithSLAOnTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("SLATimerMode", (Object)"false").get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        JPAAuditLogService logService = new JPAAuditLogService(this.emf);
        this.assertNodeInstanceSLACompliance(logService, processInstance.getId(), "Hello", 1, 0);
        this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        this.assertNodeInstanceSLACompliance(logService, processInstance.getId(), "Hello", 1, 0);
        runtime.getTaskService().start(((TaskSummary)tasks.get(0)).getId().longValue(), "john");
        runtime.getTaskService().complete(((TaskSummary)tasks.get(0)).getId().longValue(), "john", null);
        this.assertNodeInstanceSLACompliance(logService, processInstance.getId(), "Hello", 2, 1);
    }

    @Test
    public void testDontSignalCompletedSLATrackingOnUserTask() throws Exception {
        CountDownAsyncJobListener countDownListener = this.configureListener(1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithSLAOnTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("SLATimerMode", (Object)"false").get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Thread.sleep(3000L);
        runtime.getTaskService().start(((TaskSummary)tasks.get(0)).getId().longValue(), "john");
        runtime.getTaskService().complete(((TaskSummary)tasks.get(0)).getId().longValue(), "john", null);
        countDownListener.reset(1);
        Long requestInfoId = this.scheduleSLATracking(this.manager.getIdentifier());
        countDownListener.waitTillCompleted();
        Assert.assertNull((Object)ksession.getProcessInstance(processInstance.getId()));
        RequestInfo requestInfo = this.executorService.getRequestById(requestInfoId);
        ByteArrayInputStream is = new ByteArrayInputStream(requestInfo.getResponseData());
        ExecutionResults results = (ExecutionResults)new ObjectInputStream(is).readObject();
        Assert.assertFalse((boolean)results.getData().containsKey("NodeSLASignals"));
    }

    private ExecutorService buildExecutorService() {
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.complete");
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.emf);
        this.executorService.init();
        return this.executorService;
    }

    private Long scheduleSLATracking(String identifier) {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        commandContext.setData("SingleRun", (Object)"true");
        commandContext.setData("ForDeployment", (Object)identifier);
        return this.executorService.scheduleRequest("org.jbpm.executor.commands.SLATrackingCommand", commandContext);
    }

    private void assertProcessInstanceSLACompliance(JPAAuditLogService logService, Long processInstanceId, int slaCompliance) {
        List logs = ((ProcessInstanceLogQueryBuilder)logService.processInstanceLogQuery().processInstanceId(new long[]{processInstanceId})).build().getResultList();
        Assert.assertEquals((long)1L, (long)logs.size());
        ProcessInstanceLog log = (ProcessInstanceLog)logs.get(0);
        Assert.assertEquals((Object)processInstanceId, (Object)log.getProcessInstanceId());
        Assert.assertEquals((long)slaCompliance, (long)((org.jbpm.process.audit.ProcessInstanceLog)log).getSlaCompliance().intValue());
    }

    private void assertNodeInstanceSLACompliance(JPAAuditLogService logService, Long processInstanceId, String name, int slaCompliance, int type) {
        List logs = ((NodeInstanceLogQueryBuilder)((NodeInstanceLogQueryBuilder)((NodeInstanceLogQueryBuilder)logService.nodeInstanceLogQuery().processInstanceId(new long[]{processInstanceId})).and()).nodeName(new String[]{name}).and()).build().getResultList().stream().filter(log -> log.getType() == type).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)logs.size());
        NodeInstanceLog log2 = (NodeInstanceLog)logs.get(0);
        Assert.assertEquals((Object)processInstanceId, (Object)log2.getProcessInstanceId());
        Assert.assertEquals((long)slaCompliance, (long)((org.jbpm.process.audit.NodeInstanceLog)log2).getSlaCompliance().intValue());
    }
}

