/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RuleSetNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        return new RuleSetNode();
    }

    @Override
    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        String ruleFlowGroup = element.getAttribute("ruleFlowGroup");
        if (ruleFlowGroup != null && ruleFlowGroup.length() > 0) {
            ruleSetNode.setRuleFlowGroup(ruleFlowGroup);
        }
    }

    public Class generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("ruleSet", (Node)ruleSetNode, xmlDump, includeMeta);
        String ruleFlowGroup = ruleSetNode.getRuleFlowGroup();
        if (ruleFlowGroup != null) {
            xmlDump.append("ruleFlowGroup=\"" + ruleFlowGroup + "\" ");
        }
        if (ruleSetNode.getTimers() != null || includeMeta && this.containsMetaData((Node)ruleSetNode)) {
            xmlDump.append(">\n");
            if (ruleSetNode.getTimers() != null) {
                this.writeTimers(ruleSetNode.getTimers(), xmlDump);
            }
            if (includeMeta) {
                this.writeMetaData((Node)ruleSetNode, xmlDump);
            }
            this.endNode("ruleSet", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

