/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.java;

import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.jbpm.process.builder.ActionBuilder;
import org.jbpm.process.builder.AssignmentBuilder;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessClassBuilder;
import org.jbpm.process.builder.ProcessErrorHandler;
import org.jbpm.process.builder.ProcessInvokerErrorHandler;
import org.jbpm.process.builder.ReturnValueEvaluatorBuilder;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.java.JavaActionBuilder;
import org.jbpm.process.builder.dialect.java.JavaProcessClassBuilder;
import org.jbpm.process.builder.dialect.java.JavaReturnValueEvaluatorBuilder;
import org.kie.definition.process.Process;

public class JavaProcessDialect
implements ProcessDialect {
    private static final ActionBuilder actionBuilder = new JavaActionBuilder();
    private static final ProcessClassBuilder processClassBuilder = new JavaProcessClassBuilder();
    private static final ReturnValueEvaluatorBuilder returnValueBuilder = new JavaReturnValueEvaluatorBuilder();

    @Override
    public void addProcess(ProcessBuildContext context) {
        JavaDialect javaDialect = (JavaDialect)context.getDialectRegistry().getDialect("java");
        String processClass = processClassBuilder.buildRule(context);
        if (processClass == null) {
            return;
        }
        Process process = context.getProcess();
        ProcessDescr processDescr = context.getProcessDescr();
        javaDialect.addClassCompileTask(context.getPkg().getName() + "." + processDescr.getClassName(), (BaseDescr)processDescr, processClass, null, (PackageBuilder.ErrorHandler)new ProcessErrorHandler((BaseDescr)processDescr, process, "Process Compilation error"));
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(javaDialect.getId());
        for (String className : context.getInvokers().keySet()) {
            Object invoker = context.getInvokerLookups().get(className);
            if (invoker != null) {
                data.putInvoker(className, invoker);
            }
            String text = (String)context.getInvokers().get(className);
            BaseDescr descr = (BaseDescr)context.getDescrLookups().get(className);
            javaDialect.addClassCompileTask(className, descr, text, null, (PackageBuilder.ErrorHandler)new ProcessInvokerErrorHandler((BaseDescr)processDescr, process, "Unable to generate action invoker."));
        }
    }

    @Override
    public ActionBuilder getActionBuilder() {
        return actionBuilder;
    }

    @Override
    public ProcessClassBuilder getProcessClassBuilder() {
        return processClassBuilder;
    }

    @Override
    public ReturnValueEvaluatorBuilder getReturnValueEvaluatorBuilder() {
        return returnValueBuilder;
    }

    @Override
    public AssignmentBuilder getAssignmentBuilder() {
        throw new UnsupportedOperationException("Java assignments not supported");
    }
}

