/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.mvel;

import java.util.HashMap;
import java.util.Set;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.ReturnValueDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.Wireable;
import org.jbpm.process.builder.ReturnValueEvaluatorBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.impl.MVELReturnValueEvaluator;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.kie.api.runtime.process.ProcessContext;

public class MVELReturnValueEvaluatorBuilder
implements ReturnValueEvaluatorBuilder {
    @Override
    public void build(PackageBuildContext context, ReturnValueConstraintEvaluator constraintNode, ReturnValueDescr descr, ContextResolver contextResolver) {
        String text = descr.getText();
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            boolean typeSafe = context.isTypesafe();
            HashMap<String, Class> variables = new HashMap<String, Class>();
            context.setTypesafe(false);
            BoundIdentifiers boundIdentifiers = new BoundIdentifiers(variables, context.getPackageBuilder().getGlobals());
            MVELAnalysisResult analysis = (MVELAnalysisResult)dialect.analyzeBlock(context, (BaseDescr)descr, dialect.getInterceptors(), text, boundIdentifiers, null, "context", ProcessContext.class);
            context.setTypesafe(typeSafe);
            Set variableNames = analysis.getNotBoundedIdentifiers();
            if (contextResolver != null) {
                for (String variableName : variableNames) {
                    if (analysis.getMvelVariables().keySet().contains(variableName) || variableName.equals("kcontext") || variableName.equals("context")) continue;
                    VariableScope variableScope = (VariableScope)contextResolver.resolveContext("VariableScope", (Object)variableName);
                    if (variableScope == null) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)descr, null, "Could not find variable '" + variableName + "' for action '" + descr.getText() + "'"));
                        continue;
                    }
                    variables.put(variableName, context.getDialect().getTypeResolver().resolveType(variableScope.findVariable(variableName).getType().getStringType()));
                }
            }
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, (AnalysisResult)analysis, null, null, variables, context, "context", ProcessContext.class);
            MVELReturnValueEvaluator expr = new MVELReturnValueEvaluator(unit, dialect.getId());
            constraintNode.setEvaluator((ReturnValueEvaluator)expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
            data.addCompileable((Wireable)constraintNode, (MVELCompileable)expr);
            expr.compile(data);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)descr, null, "Unable to build expression for 'constraint' " + descr.getText() + "': " + e));
        }
    }

    public static String delimitExpressions(String s) {
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
        }
        return result.toString();
    }
}

