/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem;

import java.util.Map;
import org.jbpm.process.workitem.WorkItemRepository;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class WorkItemRepositoryTest
extends AbstractBaseTest {
    @Test
    public void testGetWorkDefinitions() throws Exception {
        Map repoResults = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource("repository").toURI().toString());
        Assert.assertNotNull((Object)repoResults);
        Assert.assertFalse((boolean)repoResults.isEmpty());
        Assert.assertEquals((long)repoResults.size(), (long)6L);
    }

    @Test
    public void testGetWorkDefinitionsForNames() throws Exception {
        Map repoResults = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource("repository").toURI().toString(), (String[])new String[]{"TestServiceOne", "TestServiceTwo"});
        Assert.assertNotNull((Object)repoResults);
        Assert.assertFalse((boolean)repoResults.isEmpty());
        Assert.assertEquals((long)repoResults.size(), (long)2L);
    }

    @Test
    public void testGetWorkDefinitionsForInvalidNames() throws Exception {
        Map repoResults = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource("repository").toURI().toString(), (String[])new String[]{"TestServiceOne", "INVALID_NAME"});
        Assert.assertNotNull((Object)repoResults);
        Assert.assertFalse((boolean)repoResults.isEmpty());
        Assert.assertEquals((long)repoResults.size(), (long)1L);
        Map repoResults2 = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource("repository").toURI().toString(), (String[])new String[]{"INVALID_NAME1", "INVALID_NAME2"});
        Assert.assertNotNull((Object)repoResults2);
        Assert.assertTrue((boolean)repoResults2.isEmpty());
        Map repoResults3 = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource("repository").toURI().toString(), (String[])new String[0]);
        Assert.assertNotNull((Object)repoResults3);
        Assert.assertTrue((boolean)repoResults3.isEmpty());
    }
}

