/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.IntegerDataType;
import org.drools.core.process.core.datatype.impl.type.ListDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.datatype.impl.type.StringDataType;
import org.drools.core.process.core.impl.ParameterDefinitionImpl;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.jbpm.compiler.xml.ProcessSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.Swimlane;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.Trigger;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.WorkflowProcess;
import org.w3c.dom.Document;

public class XMLPersistenceTest
extends XMLTestCase {
    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }

    @Test
    public void testPersistenceOfEmptyNodes() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess(){
            private static final long serialVersionUID = 510L;
            int id = 0;

            public void addNode(Node node) {
                ((org.jbpm.workflow.core.Node)node).setId((long)(++this.id));
                super.addNode(node);
            }
        };
        process.addNode((Node)new StartNode());
        process.addNode((Node)new EndNode());
        process.addNode((Node)new ActionNode());
        process.addNode((Node)new Split());
        process.addNode((Node)new Join());
        process.addNode((Node)new MilestoneNode());
        process.addNode((Node)new RuleSetNode());
        process.addNode((Node)new SubProcessNode());
        process.addNode((Node)new WorkItemNode());
        process.addNode((Node)new TimerNode());
        process.addNode((Node)new HumanTaskNode());
        process.addNode((Node)new ForEachNode());
        process.addNode((Node)new CompositeContextNode());
        process.addNode((Node)new EventNode());
        process.addNode((Node)new FaultNode());
        process.addNode((Node)new StateNode());
        process.addNode((Node)new DynamicNode());
        String xml = XmlRuleFlowProcessDumper.INSTANCE.dump((WorkflowProcess)process, false);
        if (xml == null) {
            throw new IllegalArgumentException("Failed to persist empty nodes!");
        }
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new ProcessSemanticModule());
        XmlProcessReader reader = new XmlProcessReader(modules, ((Object)((Object)this)).getClass().getClassLoader());
        List processes = reader.read((Reader)new StringReader(xml));
        XMLPersistenceTest.assertNotNull((Object)processes);
        process = (RuleFlowProcess)processes.get(0);
        if (process == null) {
            throw new IllegalArgumentException("Failed to reload process!");
        }
        XMLPersistenceTest.assertEquals((int)17, (int)process.getNodes().length);
        String xml2 = XmlRuleFlowProcessDumper.INSTANCE.dump((WorkflowProcess)process, false);
        if (xml2 == null) {
            throw new IllegalArgumentException("Failed to persist empty nodes!");
        }
        this.assertXMLEqual(xml, xml2);
    }

    @Test
    public void testPersistenceOfFullNodes() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess(){
            private static final long serialVersionUID = 510L;
            int id = 0;

            public void addNode(Node node) {
                ((org.jbpm.workflow.core.Node)node).setId((long)(++this.id));
                super.addNode(node);
            }
        };
        process.setMetaData("routerLayout", (Object)1);
        HashSet<String> imports = new HashSet<String>();
        imports.add("import1");
        imports.add("import2");
        process.setImports(imports);
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("name1", "type1");
        globals.put("name2", "type2");
        process.setGlobals(globals);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("variable1");
        variable.setType((DataType)new StringDataType());
        variable.setValue((Object)"value");
        variables.add(variable);
        variable = new Variable();
        variable.setName("variable2");
        variable.setType((DataType)new IntegerDataType());
        variable.setValue((Object)2);
        variables.add(variable);
        variable = new Variable();
        variable.setName("variable3");
        variable.setType((DataType)new ObjectDataType("org.jbpm.integrationtests.test.Person"));
        Person person = new Person();
        person.setName("John");
        variable.setValue((Object)person);
        variables.add(variable);
        variable = new Variable();
        variable.setName("variable4");
        ListDataType listDataType = new ListDataType();
        listDataType.setType((DataType)new ObjectDataType("java.lang.Integer"));
        variable.setType((DataType)listDataType);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(10);
        list.add(20);
        variable.setValue(list);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        Swimlane swimlane = new Swimlane();
        swimlane.setName("actor1");
        process.getSwimlaneContext().addSwimlane(swimlane);
        swimlane = new Swimlane();
        swimlane.setName("actor2");
        process.getSwimlaneContext().addSwimlane(swimlane);
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setFaultVariable("faultVariable");
        DroolsConsequenceAction action = new DroolsConsequenceAction("dialect", "consequence");
        exceptionHandler.setAction((DroolsAction)action);
        process.getExceptionScope().setExceptionHandler("myFault", (ExceptionHandler)exceptionHandler);
        exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setFaultVariable("faultVariable2");
        action = new DroolsConsequenceAction("dialect2", "consequence2");
        exceptionHandler.setAction((DroolsAction)action);
        process.getExceptionScope().setExceptionHandler("myFault2", (ExceptionHandler)exceptionHandler);
        StartNode startNode = new StartNode();
        startNode.setName("start");
        startNode.setMetaData("x", (Object)1);
        startNode.setMetaData("y", (Object)2);
        startNode.setMetaData("width", (Object)3);
        startNode.setMetaData("height", (Object)4);
        startNode.setMetaData("meta1", (Object)"someValue");
        startNode.setMetaData("meta2", (Object)"someOtherValue");
        ConstraintTrigger constraintTrigger = new ConstraintTrigger();
        constraintTrigger.setConstraint("constraint");
        HashMap<String, String> inMapping = new HashMap<String, String>();
        inMapping.put("key", "value");
        inMapping.put("key2", "value2");
        constraintTrigger.setInMappings(inMapping);
        startNode.addTrigger((Trigger)constraintTrigger);
        EventTrigger eventTrigger = new EventTrigger();
        EventTypeFilter eventTypeFilter = new EventTypeFilter();
        eventTypeFilter.setType("eventType");
        eventTrigger.addEventFilter((EventFilter)eventTypeFilter);
        inMapping = new HashMap();
        inMapping.put("key", "value");
        inMapping.put("key2", "value2");
        eventTrigger.setInMappings(inMapping);
        startNode.addTrigger((Trigger)eventTrigger);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("action");
        actionNode.setMetaData("x", (Object)1);
        actionNode.setMetaData("y", (Object)2);
        actionNode.setMetaData("width", (Object)3);
        actionNode.setMetaData("height", (Object)4);
        action = new DroolsConsequenceAction("dialect", "consequence");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        RuleSetNode ruleSetNode = new RuleSetNode();
        ruleSetNode.setName("action");
        ruleSetNode.setMetaData("x", (Object)1);
        ruleSetNode.setMetaData("y", (Object)2);
        ruleSetNode.setMetaData("width", (Object)3);
        ruleSetNode.setMetaData("height", (Object)4);
        ruleSetNode.setRuleFlowGroup("ruleFlowGroup");
        Timer timer = new Timer();
        timer.setDelay("100");
        timer.setPeriod("100");
        action = new DroolsConsequenceAction("dialect", "consequence");
        ruleSetNode.addTimer(timer, (DroolsAction)action);
        timer = new Timer();
        timer.setDelay("200");
        timer.setPeriod("200");
        action = new DroolsConsequenceAction("dialect", "consequence");
        ruleSetNode.addTimer(timer, (DroolsAction)action);
        process.addNode((Node)ruleSetNode);
        FaultNode faultNode = new FaultNode();
        faultNode.setName("action");
        faultNode.setMetaData("x", (Object)1);
        faultNode.setMetaData("y", (Object)2);
        faultNode.setMetaData("width", (Object)3);
        faultNode.setMetaData("height", (Object)4);
        faultNode.setFaultName("faultName");
        faultNode.setFaultVariable("faultVariable");
        process.addNode((Node)faultNode);
        Split split = new Split();
        split.setName("split");
        split.setMetaData("x", (Object)1);
        split.setMetaData("y", (Object)2);
        split.setMetaData("width", (Object)3);
        split.setMetaData("height", (Object)4);
        split.setType(2);
        ConnectionImpl connection = new ConnectionImpl((Node)split, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        ConstraintImpl constraint = new ConstraintImpl();
        constraint.setName("constraint1 ><&&");
        constraint.setPriority(1);
        constraint.setDialect("dialect1");
        constraint.setType("type1");
        constraint.setConstraint("constraint-text1");
        split.setConstraint((Connection)connection, (Constraint)constraint);
        connection = new ConnectionImpl((Node)split, "DROOLS_DEFAULT", (Node)ruleSetNode, "DROOLS_DEFAULT");
        constraint = new ConstraintImpl();
        constraint.setName("constraint2");
        constraint.setPriority(2);
        constraint.setDialect("dialect2");
        constraint.setType("type2");
        constraint.setConstraint("constraint-text2");
        split.setConstraint((Connection)connection, (Constraint)constraint);
        process.addNode((Node)split);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)split, "DROOLS_DEFAULT");
        EventNode eventNode = new EventNode();
        eventNode.setName("action");
        eventNode.setMetaData("x", (Object)1);
        eventNode.setMetaData("y", (Object)2);
        eventNode.setMetaData("width", (Object)3);
        eventNode.setMetaData("height", (Object)4);
        eventNode.setVariableName("eventVariable");
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("eventType");
        eventNode.addEventFilter((EventFilter)eventFilter);
        process.addNode((Node)eventNode);
        Join join = new Join();
        join.setName("join");
        join.setMetaData("x", (Object)1);
        join.setMetaData("y", (Object)2);
        join.setMetaData("width", (Object)3);
        join.setMetaData("height", (Object)4);
        join.setType(4);
        join.setN("#{var1}");
        process.addNode((Node)join);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)ruleSetNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        MilestoneNode milestone = new MilestoneNode();
        milestone.setName("milestone");
        milestone.setMetaData("x", (Object)1);
        milestone.setMetaData("y", (Object)2);
        milestone.setMetaData("width", (Object)3);
        milestone.setMetaData("height", (Object)4);
        milestone.setConstraint("constraint");
        timer = new Timer();
        timer.setDelay("100");
        timer.setPeriod("100");
        action = new DroolsConsequenceAction("dialect", "consequence");
        milestone.addTimer(timer, (DroolsAction)action);
        timer = new Timer();
        timer.setDelay("200");
        timer.setPeriod("200");
        action = new DroolsConsequenceAction("dialect", "consequence");
        milestone.addTimer(timer, (DroolsAction)action);
        ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
        DroolsConsequenceAction action1 = new DroolsConsequenceAction("java", "System.out.println(\"action1\");");
        actions.add(action1);
        DroolsConsequenceAction action2 = new DroolsConsequenceAction("java", "System.out.println(\"action2\");");
        actions.add(action2);
        milestone.setActions("onEntry", actions);
        milestone.setActions("onExit", actions);
        process.addNode((Node)milestone);
        connection = new ConnectionImpl((Node)join, "DROOLS_DEFAULT", (Node)milestone, "DROOLS_DEFAULT");
        connection.setMetaData("bendpoints", (Object)"[10,10;20,20]");
        SubProcessNode subProcess = new SubProcessNode();
        subProcess.setName("subProcess");
        subProcess.setMetaData("x", (Object)1);
        subProcess.setMetaData("y", (Object)2);
        subProcess.setMetaData("width", (Object)3);
        subProcess.setMetaData("height", (Object)4);
        subProcess.setProcessId("processId");
        subProcess.setWaitForCompletion(false);
        subProcess.setIndependent(false);
        subProcess.addInMapping("subvar1", "var1");
        subProcess.addOutMapping("subvar2", "var2");
        timer = new Timer();
        timer.setDelay("100");
        timer.setPeriod("100");
        action = new DroolsConsequenceAction("dialect", "consequence");
        subProcess.addTimer(timer, (DroolsAction)action);
        timer = new Timer();
        timer.setDelay("200");
        timer.setPeriod("200");
        action = new DroolsConsequenceAction("dialect", "consequence");
        subProcess.addTimer(timer, (DroolsAction)action);
        subProcess.setActions("onEntry", actions);
        subProcess.setActions("onExit", actions);
        process.addNode((Node)subProcess);
        connection = new ConnectionImpl((Node)milestone, "DROOLS_DEFAULT", (Node)subProcess, "DROOLS_DEFAULT");
        connection.setMetaData("bendpoints", (Object)"[10,10]");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("WorkItem");
        WorkImpl work = new WorkImpl();
        work.setName("workname");
        HashSet<ParameterDefinitionImpl> parameterDefinitions = new HashSet<ParameterDefinitionImpl>();
        ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl("param1", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("param2", (DataType)new IntegerDataType());
        parameterDefinitions.add(parameterDefinition);
        work.setParameterDefinitions(parameterDefinitions);
        work.setParameter("param1", (Object)"value1");
        work.setParameter("param2", (Object)1);
        workItemNode.setWork((Work)work);
        workItemNode.setWaitForCompletion(false);
        workItemNode.addInMapping("param1", "var1");
        workItemNode.addOutMapping("param2", "var2");
        timer = new Timer();
        timer.setDelay("100");
        timer.setPeriod("100");
        action = new DroolsConsequenceAction("dialect", "consequence");
        workItemNode.addTimer(timer, (DroolsAction)action);
        timer = new Timer();
        timer.setDelay("200");
        timer.setPeriod("200");
        action = new DroolsConsequenceAction("dialect", "consequence");
        workItemNode.addTimer(timer, (DroolsAction)action);
        workItemNode.setActions("onEntry", actions);
        workItemNode.setActions("onExit", actions);
        process.addNode((Node)workItemNode);
        connection = new ConnectionImpl((Node)subProcess, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        connection.setMetaData("bendpoints", (Object)"[]");
        HumanTaskNode humanTaskNode = new HumanTaskNode();
        humanTaskNode.setName("Human Task");
        work = humanTaskNode.getWork();
        parameterDefinitions = new HashSet();
        parameterDefinition = new ParameterDefinitionImpl("TaskName", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("ActorId", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Priority", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        parameterDefinition = new ParameterDefinitionImpl("Comment", (DataType)new StringDataType());
        parameterDefinitions.add(parameterDefinition);
        work.setParameterDefinitions(parameterDefinitions);
        work.setParameter("TaskName", (Object)"Do something");
        work.setParameter("ActorId", (Object)"John Doe");
        humanTaskNode.setWaitForCompletion(false);
        humanTaskNode.setActions("onEntry", actions);
        humanTaskNode.setActions("onExit", actions);
        process.addNode((Node)humanTaskNode);
        connection = new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)humanTaskNode, "DROOLS_DEFAULT");
        TimerNode timerNode = new TimerNode();
        timerNode.setName("timer");
        timerNode.setMetaData("x", (Object)1);
        timerNode.setMetaData("y", (Object)2);
        timerNode.setMetaData("width", (Object)3);
        timerNode.setMetaData("height", (Object)4);
        timer = new Timer();
        timer.setDelay("1000");
        timer.setPeriod("1000");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)humanTaskNode, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ForEachNode forEachNode = new ForEachNode();
        forEachNode.setName("ForEach");
        forEachNode.setCollectionExpression("collection");
        forEachNode.setVariable("variableName", (DataType)new ObjectDataType());
        forEachNode.setWaitForCompletion(false);
        ActionNode subActionNode1 = new ActionNode();
        forEachNode.getCompositeNode().addNode((Node)subActionNode1);
        ActionNode subActionNode2 = new ActionNode();
        forEachNode.getCompositeNode().addNode((Node)subActionNode2);
        new ConnectionImpl((Node)subActionNode1, "DROOLS_DEFAULT", (Node)subActionNode2, "DROOLS_DEFAULT");
        forEachNode.getCompositeNode().linkIncomingConnections("DROOLS_DEFAULT", subActionNode1.getId(), "DROOLS_DEFAULT");
        forEachNode.getCompositeNode().linkOutgoingConnections(subActionNode2.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        process.addNode((Node)forEachNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)forEachNode, "DROOLS_DEFAULT");
        CompositeContextNode compositeNode = new CompositeContextNode();
        compositeNode.setName("Composite");
        VariableScope variableScope = new VariableScope();
        compositeNode.addContext((Context)variableScope);
        compositeNode.setDefaultContext((Context)variableScope);
        variableScope.setVariables(variables);
        ExceptionScope exceptionScope = new ExceptionScope();
        compositeNode.addContext((Context)exceptionScope);
        compositeNode.setDefaultContext((Context)exceptionScope);
        exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setFaultVariable("faultVariable");
        action = new DroolsConsequenceAction("dialect", "consequence");
        exceptionHandler.setAction((DroolsAction)action);
        exceptionScope.setExceptionHandler("MyFault", (ExceptionHandler)exceptionHandler);
        exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setFaultVariable("faultVariable2");
        action = new DroolsConsequenceAction("dialect2", "consequence2");
        exceptionHandler.setAction((DroolsAction)action);
        exceptionScope.setExceptionHandler("MyFault2", (ExceptionHandler)exceptionHandler);
        subActionNode1 = new ActionNode();
        compositeNode.addNode((Node)subActionNode1);
        subActionNode2 = new ActionNode();
        compositeNode.addNode((Node)subActionNode2);
        new ConnectionImpl((Node)subActionNode1, "DROOLS_DEFAULT", (Node)subActionNode2, "DROOLS_DEFAULT");
        compositeNode.linkIncomingConnections("DROOLS_DEFAULT", subActionNode1.getId(), "DROOLS_DEFAULT");
        compositeNode.linkOutgoingConnections(subActionNode2.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        process.addNode((Node)compositeNode);
        new ConnectionImpl((Node)forEachNode, "DROOLS_DEFAULT", (Node)compositeNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("end");
        endNode.setTerminate(false);
        endNode.setMetaData("x", (Object)1);
        endNode.setMetaData("y", (Object)2);
        endNode.setMetaData("width", (Object)3);
        endNode.setMetaData("height", (Object)4);
        process.addNode((Node)endNode);
        StateNode stateNode = new StateNode();
        stateNode.setName("state");
        stateNode.setMetaData("x", (Object)1);
        stateNode.setMetaData("y", (Object)2);
        stateNode.setMetaData("width", (Object)3);
        stateNode.setMetaData("height", (Object)4);
        timer = new Timer();
        timer.setDelay("100");
        timer.setPeriod("100");
        action = new DroolsConsequenceAction("dialect", "consequence");
        stateNode.addTimer(timer, (DroolsAction)action);
        timer = new Timer();
        timer.setDelay("200");
        timer.setPeriod("200");
        action = new DroolsConsequenceAction("dialect", "consequence");
        stateNode.addTimer(timer, (DroolsAction)action);
        actions = new ArrayList();
        action1 = new DroolsConsequenceAction("java", "System.out.println(\"action1\");");
        actions.add(action1);
        action2 = new DroolsConsequenceAction("java", "System.out.println(\"action2\");");
        actions.add(action2);
        stateNode.setActions("onEntry", actions);
        stateNode.setActions("onExit", actions);
        new ConnectionImpl((Node)compositeNode, "DROOLS_DEFAULT", (Node)stateNode, "DROOLS_DEFAULT");
        connection = new ConnectionImpl((Node)stateNode, "DROOLS_DEFAULT", (Node)join, "DROOLS_DEFAULT");
        constraint = new ConstraintImpl();
        constraint.setName("constraint1 ><&&");
        constraint.setPriority(1);
        constraint.setDialect("dialect1");
        constraint.setType("type1");
        constraint.setConstraint("constraint-text1 %&<>");
        stateNode.setConstraint((Connection)connection, (Constraint)constraint);
        connection = new ConnectionImpl((Node)stateNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        constraint = new ConstraintImpl();
        constraint.setName("constraint2");
        constraint.setPriority(2);
        constraint.setDialect("dialect2");
        constraint.setType("type2");
        constraint.setConstraint("constraint-text2");
        stateNode.setConstraint((Connection)connection, (Constraint)constraint);
        process.addNode((Node)stateNode);
        String xml = XmlRuleFlowProcessDumper.INSTANCE.dump((WorkflowProcess)process, true);
        if (xml == null) {
            throw new IllegalArgumentException("Failed to persist full nodes!");
        }
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new ProcessSemanticModule());
        XmlProcessReader reader = new XmlProcessReader(modules, ((Object)((Object)this)).getClass().getClassLoader());
        List processes = reader.read((Reader)new StringReader(xml));
        XMLPersistenceTest.assertNotNull((Object)processes);
        process = (RuleFlowProcess)processes.get(0);
        if (process == null) {
            throw new IllegalArgumentException("Failed to reload process!");
        }
        XMLPersistenceTest.assertEquals((int)16, (int)process.getNodes().length);
        XMLPersistenceTest.assertEquals((int)2, (int)process.getImports().size());
        XMLPersistenceTest.assertEquals((int)2, (int)process.getGlobals().size());
        XMLPersistenceTest.assertEquals((int)4, (int)process.getVariableScope().getVariables().size());
        XMLPersistenceTest.assertEquals((int)2, (int)process.getSwimlaneContext().getSwimlanes().size());
        XMLPersistenceTest.assertEquals((int)2, (int)process.getExceptionScope().getExceptionHandlers().size());
        String xml2 = XmlRuleFlowProcessDumper.INSTANCE.dump((WorkflowProcess)process, true);
        if (xml2 == null) {
            throw new IllegalArgumentException("Failed to persist empty nodes!");
        }
        Document control = XMLUnit.buildDocument((DocumentBuilder)XMLUnit.newControlParser(), (Reader)new StringReader(xml));
        Document test = XMLUnit.buildDocument((DocumentBuilder)XMLUnit.newTestParser(), (Reader)new StringReader(xml2));
        Diff diff = new Diff(control, test, null, (ElementQualifier)new ElementNameAndAttributeQualifier("name"));
        XMLPersistenceTest.assertTrue((String)diff.toString(), (boolean)diff.similar());
    }

    public void testSpecialCharacters() {
    }
}

