/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.MarshallingConfigurationImpl;
import org.drools.core.marshalling.impl.ProtobufMarshaller;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProcessInstanceResolverStrategyTest
extends AbstractBaseTest {
    private static final String PROCESS_NAME = "simpleProcess.xml";

    @Test
    public void testAccept() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setState(1);
        processInstance.setProcess((Process)process);
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)ksession);
        ProcessInstanceResolverStrategy strategy = new ProcessInstanceResolverStrategy();
        Assert.assertTrue((boolean)strategy.accept((Object)processInstance));
        Object object = new Object();
        Assert.assertTrue((!strategy.accept(object) ? 1 : 0) != 0);
    }

    @Test
    public void testProcessInstanceResolverStrategy() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource(PROCESS_NAME, this.getClass()), ResourceType.DRF);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ProcessInstance processInstance = ksession.createProcessInstance("process name", new HashMap());
        ksession.insert((Object)processInstance);
        ProcessInstanceResolverStrategy strategy = new ProcessInstanceResolverStrategy();
        ObjectMarshallingStrategy[] strategies = new ObjectMarshallingStrategy[]{strategy, MarshallerFactory.newSerializeMarshallingStrategy()};
        MarshallingConfigurationImpl marshallingConfig = new MarshallingConfigurationImpl(strategies, true, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerWriteContext writerContext = new MarshallerWriteContext((OutputStream)baos, (InternalKnowledgeBase)kbase, (InternalWorkingMemory)((StatefulKnowledgeSessionImpl)ksession), RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((InternalKnowledgeBase)kbase)), marshallingConfig.getObjectMarshallingStrategyStore(), marshallingConfig.isMarshallProcessInstances(), marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        strategy.write((ObjectOutputStream)writerContext, (Object)processInstance);
        baos.close();
        writerContext.close();
        byte[] bytes = baos.toByteArray();
        int numCorrectBytes = this.calculateNumBytesForLong(processInstance.getId());
        Assert.assertTrue((String)("Expected " + numCorrectBytes + " bytes, not " + bytes.length), (bytes.length == numCorrectBytes ? 1 : 0) != 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        long serializedProcessInstanceId = ois.readLong();
        Assert.assertTrue((String)("Expected " + processInstance.getId() + ", not " + serializedProcessInstanceId), (processInstance.getId() == serializedProcessInstanceId ? 1 : 0) != 0);
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager((Object)writerContext);
        Assert.assertNotNull((Object)pim);
        Assert.assertNotNull((Object)ProcessInstanceResolverStrategy.retrieveKnowledgeRuntime((Object)writerContext));
        Assert.assertTrue((processInstance == pim.getProcessInstance(serializedProcessInstanceId) ? 1 : 0) != 0);
        bais = new ByteArrayInputStream(bytes);
        MarshallerReaderContext readerContext = new MarshallerReaderContext((InputStream)bais, (InternalKnowledgeBase)((KnowledgeBaseImpl)kbase), RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((KnowledgeBaseImpl)kbase)), marshallingConfig.getObjectMarshallingStrategyStore(), ProtobufMarshaller.TIMER_READERS, marshallingConfig.isMarshallProcessInstances(), marshallingConfig.isMarshallWorkItems(), EnvironmentFactory.newEnvironment());
        readerContext.wm = ((StatefulKnowledgeSessionImpl)ksession).getInternalWorkingMemory();
        Object procInstObject = strategy.read((ObjectInputStream)readerContext);
        Assert.assertTrue((procInstObject != null && procInstObject instanceof ProcessInstance ? 1 : 0) != 0);
        Assert.assertTrue((processInstance == procInstObject ? 1 : 0) != 0);
    }

    private int calculateNumBytesForLong(Long longVal) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeLong(longVal);
        baos.close();
        oos.close();
        return baos.toByteArray().length;
    }
}

