/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.io.impl.ReaderResource;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.WorkflowProcessInstanceUpgrader;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProcessUpgradeTest
extends AbstractBaseTest {
    @Test
    public void testDefaultUpgrade() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "  ruleflow-group \"hello\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add((Resource)new ReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.test.ruleflow");
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <actionNode id=\"4\" name=\"Action\" >      <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"4\"/>\n    <connection from=\"4\" to=\"3\"/>\n  </connections>\n</process>";
        builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add((Resource)new ReaderResource((Reader)new StringReader(process2)), ResourceType.DRF);
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KieRuntime)session, (long)processInstance.getId(), (String)"org.test.ruleflow2", new HashMap());
        Assert.assertEquals((Object)"org.test.ruleflow2", (Object)processInstance.getProcessId());
        session.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testMappingUpgrade() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "  ruleflow-group \"hello\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add((Resource)new ReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.test.ruleflow");
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"102\" name=\"Hello\" >\n      <work name=\"Human Task\" >\n      </work>\n    </workItem>\n    <actionNode id=\"4\" name=\"Action\" >      <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"102\"/>\n    <connection from=\"102\" to=\"4\"/>\n    <connection from=\"4\" to=\"3\"/>\n  </connections>\n</process>";
        builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add((Resource)new ReaderResource((Reader)new StringReader(process2)), ResourceType.DRF);
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        HashMap<String, Long> mapping = new HashMap<String, Long>();
        mapping.put("2", 102L);
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KieRuntime)session, (long)processInstance.getId(), (String)"org.test.ruleflow2", mapping);
        Assert.assertEquals((Object)"org.test.ruleflow2", (Object)processInstance.getProcessId());
        session.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testCompositeMappingUpgrade() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "  ruleflow-group \"hello\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add((Resource)new ByteArrayResource(rule.getBytes()), ResourceType.DRL);
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <composite id=\"2\" name=\"Composite\" >\n      <nodes>\n        <workItem id=\"1\" name=\"Hello\" >\n          <work name=\"Human Task\" >\n          </work>\n        </workItem>\n      </nodes>\n      <connections>\n      </connections>\n      <in-ports>\n        <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n      </in-ports>\n      <out-ports>\n        <out-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeOutType=\"DROOLS_DEFAULT\" />\n      </out-ports>\n    </composite>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        builder.add((Resource)new ReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        ProcessInstance processInstance = (ProcessInstance)session.startProcess("org.test.ruleflow");
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <composite id=\"2\" name=\"Composite\" >\n      <nodes>\n        <workItem id=\"101\" name=\"Hello\" >\n          <work name=\"Human Task\" >\n          </work>\n        </workItem>\n        <actionNode id=\"2\" name=\"Action\" >          <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"101\" to=\"2\"/>\n      </connections>\n      <in-ports>\n        <in-port type=\"DROOLS_DEFAULT\" nodeId=\"101\" nodeInType=\"DROOLS_DEFAULT\" />\n      </in-ports>\n      <out-ports>\n        <out-port type=\"DROOLS_DEFAULT\" nodeId=\"2\" nodeOutType=\"DROOLS_DEFAULT\" />\n      </out-ports>\n    </composite>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add((Resource)new ReaderResource((Reader)new StringReader(process2)), ResourceType.DRF);
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        HashMap<String, Long> mapping = new HashMap<String, Long>();
        mapping.put("2:1", 101L);
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KieRuntime)session, (long)processInstance.getId(), (String)"org.test.ruleflow2", mapping);
        Assert.assertEquals((Object)"org.test.ruleflow2", (Object)processInstance.getProcessId());
        session.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }
}

