/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.builder.dialect.javascript.JavaScriptActionBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;

public class JavaScriptActionBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleAction() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("var testString; print('Hello')");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ProcessBuildContext context = new ProcessBuildContext(pkgBuilder, pkgBuilder.getPackage(), null, (BaseDescr)processDescr, dialectRegistry, null);
        context.init(pkgBuilder, (InternalKnowledgePackage)pkg, null, dialectRegistry, null, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal String testField;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("JavaScript", null);
        actionNode.setAction((DroolsAction)action);
        ProcessDialect dialect = ProcessDialectRegistry.getDialect((String)"JavaScript");
        dialect.getActionBuilder().build((PackageBuildContext)context, (DroolsAction)action, actionDescr, (ContextResolver)actionNode);
        dialect.addProcess(context);
        JavaScriptActionBuilder builder = new JavaScriptActionBuilder();
        builder.build((PackageBuildContext)context, (DroolsAction)action, actionDescr, (ContextResolver)actionNode);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(pkgBuilder.getPackage()));
        KieSession wm = kbase.newKieSession();
        wm.setGlobal("testField", (Object)"vagon");
        org.drools.core.spi.ProcessContext processContext = new org.drools.core.spi.ProcessContext((KieRuntime)((InternalWorkingMemory)wm).getKnowledgeRuntime());
        ((Action)actionNode.getAction().getMetaData("Action")).execute((ProcessContext)processContext);
        Assert.assertEquals((Object)"vagon", (Object)wm.getGlobal("testField").toString());
    }
}

