/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.jbpm.process.builder.dialect.mvel.MVELActionBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.MVELAction;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;

public class MVELActionBuilderTest
extends AbstractBaseTest {
    @Test
    public void testSimpleAction() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("list.add( 'hello world' )");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init(pkgBuilder, (InternalKnowledgePackage)pkg, null, dialectRegistry, (Dialect)mvelDialect, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal java.util.List list;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("mvel", null);
        actionNode.setAction((DroolsAction)action);
        MVELActionBuilder builder = new MVELActionBuilder();
        builder.build(context, (DroolsAction)action, actionDescr, (ContextResolver)actionNode);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(pkgBuilder.getPackage()));
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkgBuilder.getPackage().getDialectRuntimeRegistry().getDialectData("mvel");
        ((MVELAction)actionNode.getAction().getMetaData("Action")).compile(data);
        org.drools.core.spi.ProcessContext processContext = new org.drools.core.spi.ProcessContext((KieRuntime)((InternalWorkingMemory)wm).getKnowledgeRuntime());
        ((Action)actionNode.getAction().getMetaData("Action")).execute((ProcessContext)processContext);
        Assert.assertEquals((Object)"hello world", list.get(0));
    }
}

