/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.util.ArrayList;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.DebugProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgendaFilterTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AgendaFilterTest.class);

    @Test
    public void testAgendaFilter() {
        String drl = "package org.drools\n \nimport org.jbpm.integrationtests.AgendaFilterTest.Message\n \nrule \"R1\"\nruleflow-group \"node1\"\nno-loop \nsalience 3\n    when\n        Message( status == Message.GOODBYE, myMessage : message )\n    then\n       System.out.println( \"R1\"  );\nend\n\nrule \"R2\"\nruleflow-group \"node1\"\nno-loop \nsalience 2\n    when\n        m : Message( status == Message.HELLO, myMessage : message )\n    then\n        System.out.println( \"R2\"  );\n        m.setMessage( \"Goodbye cruel world\" );\n        m.setStatus( Message.GOODBYE );\n        update( m );\nend\n\nrule \"R3\"\nruleflow-group \"node2\"\nno-loop \n    when\n        m: Message( status == Message.GOODBYE, myMessage : message )\n    then\n        System.out.println( \"R3\"  );\n        m.setStatus(5);\n        update (m);\n        \nend";
        String rf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"process-test\" package-name=\"com.sample\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" x=\"122\" y=\"96\" width=\"48\" height=\"48\" />\n    <ruleSet id=\"2\" name=\"Node1\" x=\"277\" y=\"96\" width=\"80\" height=\"48\" ruleFlowGroup=\"node1\" />\n    <ruleSet id=\"3\" name=\"Node2\" x=\"433\" y=\"98\" width=\"80\" height=\"48\" ruleFlowGroup=\"node2\" />\n    <end id=\"4\" name=\"End\" x=\"645\" y=\"96\" width=\"48\" height=\"48\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n\n</process>";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rf.getBytes()), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        StatefulKnowledgeSession ksession = this.createKieSession(kbuilder.getKnowledgePackages().toArray(new KnowledgePackage[0]));
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.startProcess("process-test");
        Assert.assertEquals((Object)"Goodbye cruel world", (Object)message.getMessage());
    }

    @Test
    public void testActivationCancelled() {
        String drl = "package org.jboss.qa.brms.agendafilter\ndeclare CancelFact\n   cancel : boolean = true\nend\nrule NoCancel\n   ruleflow-group \"rfg\"\n   when\n       $fact : CancelFact ( cancel == false )\n   then\n       System.out.println(\"No cancel...\");\n       modify ($fact) {\n           setCancel(true);\n       }\nend\nrule PresenceOfBothFacts\n   ruleflow-group \"rfg\"\n   salience -1\n   when\n       $fact1 : CancelFact( cancel == false )\n       $fact2 : CancelFact( cancel == true )\n   then\n       System.out.println(\"Both facts!\");\nend\nrule PresenceOfFact\n   ruleflow-group \"rfg\"\n   when\n       $fact : CancelFact( )\n   then\n       System.out.println(\"We have a \" + ($fact.isCancel() ? \"\" : \"non-\") + \"cancelling fact!\");\nend\nrule Cancel\n   ruleflow-group \"rfg\"\n   when\n       $fact : CancelFact ( cancel == true )\n   then\n       System.out.println(\"Cancel!\");\nend";
        String rf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"bz761715\" package-name=\"org.jboss.qa.brms.agendafilter\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" x=\"16\" y=\"16\" width=\"48\" height=\"48\" />\n    <ruleSet id=\"2\" name=\"Rule\" x=\"208\" y=\"16\" width=\"80\" height=\"48\" ruleFlowGroup=\"rfg\" />\n    <actionNode id=\"3\" name=\"Script\" x=\"320\" y=\"16\" width=\"80\" height=\"48\" >\n        <action type=\"expression\" dialect=\"java\" >System.out.println(\"Finishing process...\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" x=\"432\" y=\"16\" width=\"48\" height=\"48\" />\n    <actionNode id=\"5\" name=\"Script\" x=\"96\" y=\"16\" width=\"80\" height=\"48\" >\n        <action type=\"expression\" dialect=\"java\" >System.out.println(\"Starting process...\");</action>\n    </actionNode>\n  </nodes>\n  <connections>\n    <connection from=\"5\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"1\" to=\"5\" />\n  </connections>\n</process>";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rf.getBytes()), ResourceType.DRF);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ksession.addEventListener((ProcessEventListener)new DebugProcessEventListener());
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(CommandFactory.newInsert((Object)this.newCancelFact(ksession, false)));
        commands.add(CommandFactory.newInsert((Object)this.newCancelFact(ksession, true)));
        commands.add(CommandFactory.newStartProcess((String)"bz761715"));
        commands.add(new FireAllRulesCommand((AgendaFilter)new CancelAgendaFilter()));
        commands.add(new FireAllRulesCommand((AgendaFilter)new CancelAgendaFilter()));
        commands.add(new FireAllRulesCommand((AgendaFilter)new CancelAgendaFilter()));
        ksession.execute((Command)CommandFactory.newBatchExecution(commands));
    }

    private Object newCancelFact(StatefulKnowledgeSession ksession, boolean cancel) {
        FactType type = ksession.getKieBase().getFactType("org.jboss.qa.brms.agendafilter", "CancelFact");
        Object instance = null;
        try {
            instance = type.newInstance();
            type.set(instance, "cancel", (Object)cancel);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        return instance;
    }

    @Test
    public void testGetListeners() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        StatefulKnowledgeSession ksession = kbuilder.newKnowledgeBase().newStatefulKnowledgeSession();
        ksession.getAgendaEventListeners();
        ksession.getProcessEventListeners();
        ksession.getRuleRuntimeEventListeners();
        ksession.dispose();
    }

    public static class CancelAgendaFilter
    implements AgendaFilter {
        public boolean accept(Match activation) {
            return !"Cancel".equals(activation.getRule().getName());
        }
    }

    public static class SalienceFilter
    implements AgendaFilter {
        private Integer currentSalience = null;

        public boolean accept(Match activation) {
            boolean nocancel;
            RuleImpl rule = (RuleImpl)activation.getRule();
            if (this.currentSalience == null) {
                this.currentSalience = rule.getSalience() != null ? Integer.valueOf(rule.getSalience().toString()) : 0;
            }
            boolean bl = nocancel = this.currentSalience >= Integer.valueOf(rule.getSalience().toString());
            if (!nocancel) {
                logger.info("cancelling -> {}", (Object)rule.getName());
            }
            return nocancel;
        }
    }

    public static class Message {
        public static final int HELLO = 0;
        public static final int GOODBYE = 1;
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

