/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.jbpm.integrationtests.JbpmSerializationHelper;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

public abstract class AbstractBaseTest {
    protected KnowledgeBuilderImpl builder;

    @Before
    public void before() {
        this.builder = new KnowledgeBuilderImpl();
    }

    public StatefulKnowledgeSession createKieSession(KnowledgePackage ... pkg) {
        try {
            return this.createKieSession(false, pkg);
        }
        catch (Exception e) {
            String msg = "There's no reason fo an exception to be thrown here (because the kbase is not being serialized)!";
            Assert.fail((String)msg);
            throw new RuntimeException(msg, e);
        }
    }

    public StatefulKnowledgeSession createKieSession(boolean serializeKbase, KnowledgePackage ... pkg) throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Arrays.asList(pkg));
        if (serializeKbase) {
            kbase = JbpmSerializationHelper.serializeObject(kbase);
        }
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        return kbase.newStatefulKnowledgeSession(conf, null);
    }

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }
}

