/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import junit.framework.TestCase;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.ReturnValueDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.javascript.JavaScriptReturnValueEvaluatorBuilder;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.SplitInstance;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;

public class JavaScriptReturnValueConstraintEvaluatorBuilderTest {
    @Test
    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("function validate() {return value;} validate();");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        ProcessBuildContext context = new ProcessBuildContext((DroolsAssemblerContext)pkgBuilder, (InternalKnowledgePackage)pkg, (Process)process, (BaseDescr)processDescr, dialectRegistry, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\n global Boolean value;\n"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        JavaScriptReturnValueEvaluatorBuilder builder = new JavaScriptReturnValueEvaluatorBuilder();
        builder.build((PackageBuildContext)context, node, descr, null);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(pkgBuilder.getPackages()));
        KieSession ksession = kbase.newKieSession();
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)ksession);
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        ksession.setGlobal("value", (Object)true);
        Assert.assertTrue((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
        ReturnValueDescr descr2 = new ReturnValueDescr();
        descr.setText("function invalidate() {return false;} invalidate();");
        JavaScriptReturnValueEvaluatorBuilder builder2 = new JavaScriptReturnValueEvaluatorBuilder();
        builder2.build((PackageBuildContext)context, node, descr, null);
        TestCase.assertFalse((boolean)node.evaluate((NodeInstance)splitInstance, null, null));
    }
}

