/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.integrationtests.JbpmSerializationHelper;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

public abstract class AbstractBaseTest {
    protected KnowledgeBuilderImpl builder;

    @Before
    public void before() {
        this.builder = new KnowledgeBuilderImpl();
    }

    public KieSession createKieSession(KiePackage ... pkg) {
        try {
            return this.createKieSession(false, pkg);
        }
        catch (Exception e) {
            String msg = "There's no reason fo an exception to be thrown here (because the kbase is not being serialized)!";
            Assert.fail((String)msg);
            throw new RuntimeException(msg, e);
        }
    }

    public KieSession createKieSession(boolean serializeKbase, KiePackage ... pkg) throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(pkg));
        if (serializeKbase) {
            kbase = JbpmSerializationHelper.serializeObject(kbase);
        }
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        return kbase.newKieSession(conf, null);
    }

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }
}

