/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.Collection;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBuilderTest
extends AbstractBaseTest {
    @Test
    public void testKnowledgeProviderWithProcesses() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" ";
        str = str + "         type=\"RuleFlow\" name=\"flow1\" id=\"0\" package-name=\"org.test1\" >";
        str = str + "  <header/>\n";
        str = str + "  <nodes><start id=\"1\" name=\"Start\" /><end id=\"2\" name=\"End\" /></nodes>\n";
        str = str + "  <connections><connection from=\"1\" to=\"2\"/></connections>";
        str = str + "</process>";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRF);
        str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" ";
        str = str + "         type=\"RuleFlow\" name=\"flow2\" id=\"0\" package-name=\"org.test2\" >";
        str = str + "  <header/>\n";
        str = str + "  <nodes><start id=\"1\" name=\"Start\" /><end id=\"2\" name=\"End\" /></nodes>\n";
        str = str + "  <connections><connection from=\"1\" to=\"2\"/></connections>";
        str = str + "</process>";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRF);
        Collection pkgs = builder.getKnowledgePackages();
        Assert.assertNotNull((Object)pkgs);
        Assert.assertEquals((long)2L, (long)pkgs.size());
        KiePackage test1 = this.getKnowledgePackage(pkgs, "org.test1");
        Collection processes = test1.getProcesses();
        Assert.assertEquals((long)1L, (long)processes.size());
        Process process = this.getProcess(processes, "flow1");
        Assert.assertEquals((Object)"flow1", (Object)process.getName());
        KiePackage test2 = this.getKnowledgePackage(pkgs, "org.test2");
        processes = test2.getProcesses();
        Assert.assertEquals((long)1L, (long)processes.size());
        process = this.getProcess(processes, "flow2");
        Assert.assertEquals((Object)"flow2", (Object)process.getName());
    }

    public Process getProcess(Collection<Process> processes, String name) {
        for (Process process : processes) {
            if (!process.getName().equals(name)) continue;
            return process;
        }
        return null;
    }

    public KiePackage getKnowledgePackage(Collection<KiePackage> pkgs, String name) {
        for (KiePackage pkg : pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }
}

