/*
 * Decompiled with CFR 0.152.
 */
package com.salaboy.example;

import com.salaboy.example.MockUserInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.Group;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.local.LocalTaskService;
import org.jbpm.task.utils.ContentMarshallerHelper;

public class HumanTaskServlet
extends HttpServlet {
    private LocalTaskService localTaskService;
    private EntityManagerFactory emf;
    private TaskService taskService;
    private TaskServiceSession taskSession;
    private Map<String, User> users = new HashMap();
    private Map<String, Group> groups = new HashMap();
    private long taskId;

    public HumanTaskServlet() {
        try {
            InitialContext ctx = new InitialContext();
            this.emf = (EntityManagerFactory)ctx.lookup("java:jboss/myTaskEntityManagerFactory");
        }
        catch (NamingException ex) {
            Logger.getLogger(HumanTaskServlet.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        System.out.println("EMF = " + this.emf);
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        this.taskSession = this.taskService.createSession();
        this.addUsersAndGroups(this.taskSession);
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        this.localTaskService = new LocalTaskService(this.taskService);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['salaboy' ], users['bobba'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("users", this.users);
        params.put("groups", this.groups);
        params.put("now", new Date());
        Task task = (Task)TaskService.eval((String)str, params);
        this.localTaskService.addTask(task, new ContentData());
        this.taskId = task.getId();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, FileUploadException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        out.println("Hi There! ");
        out.println("Task Id = " + this.taskId);
        HashMap<String, String> params = new HashMap<String, String>();
        List items = upload.parseRequest(request);
        for (FileItem item : items) {
            if (!item.isFormField()) continue;
            String name = item.getFieldName();
            String value = item.getString();
            params.put(name, value);
        }
        if (((String)params.get("action")).equals("start")) {
            this.localTaskService.start(this.taskId, "salaboy");
            out.println("Task Started!");
        }
        if (((String)params.get("action")).equals("complete")) {
            ContentData data = ContentMarshallerHelper.marshal(params, null);
            this.localTaskService.complete(this.taskId, "salaboy", data);
            out.println("Task Completed!");
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (FileUploadException ex) {
            Logger.getLogger(HumanTaskServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (FileUploadException ex) {
            Logger.getLogger(HumanTaskServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }

    private void addUsersAndGroups(TaskServiceSession taskSession) {
        User user = new User("salaboy");
        User watman = new User("watman");
        taskSession.addUser(user);
        taskSession.addUser(watman);
        User administrator = new User("Administrator");
        taskSession.addUser(administrator);
        this.users.put("salaboy", user);
        this.users.put("watman", watman);
        this.users.put("administrator", administrator);
        Group myGroup = new Group("group1");
        taskSession.addGroup(myGroup);
        this.groups.put("group1", myGroup);
    }
}

