/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FormDisplayInfo;

public class Form
implements Serializable,
Comparable {
    public static final String RENDER_MODE_FORM = "form";
    public static final String RENDER_MODE_DISPLAY = "display";
    public static final String RENDER_MODE_TEMPLATE_EDIT = "templateEdit";
    public static final String RENDER_MODE_WYSIWYG_FORM = "wysiwyg-form";
    public static final String RENDER_MODE_WYSIWYG_DISPLAY = "wysiwyg-display";
    public static final String LABEL_MODE_UNDEFINED = "undefined";
    public static final String LABEL_MODE_BEFORE = "before";
    public static final String LABEL_MODE_AFTER = "after";
    public static final String LABEL_MODE_RIGHT = "right";
    public static final String LABEL_MODE_LEFT = "left";
    public static final String LABEL_MODE_HIDDEN = "hidden";
    public static final String DISPLAY_MODE_DEFAULT = "default";
    public static final String DISPLAY_MODE_ALIGNED = "aligned";
    public static final String DISPLAY_MODE_TEMPLATE = "template";
    public static final String DISPLAY_MODE_NONE = "none";
    public static final String TEMPLATE_FIELD = "$field";
    public static final String TEMPLATE_LABEL = "$label";
    private Long id;
    private String subject;
    private String name;
    private String displayMode;
    private String labelMode;
    private String showMode;
    private Long status;
    private Set<FormDisplayInfo> formDisplayInfos;
    private Set<Field> formFields = new TreeSet<Field>();
    private Set<DataHolder> holders;
    private HashMap subForms = new HashMap();
    private HashMap dataHolderRenderInfo = new HashMap();

    public Form() {
        this.formDisplayInfos = new TreeSet<FormDisplayInfo>();
        this.holders = new TreeSet<DataHolder>();
    }

    public Long getId() {
        return this.id;
    }

    public String getItemClassName() {
        return Form.class.getName();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getLabelMode() {
        return this.labelMode;
    }

    public void setLabelMode(String labelMode) {
        this.labelMode = labelMode;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public boolean isVisibleStatus() {
        return 0L == this.getStatus();
    }

    public Set<FormDisplayInfo> getFormDisplayInfos() {
        return this.formDisplayInfos;
    }

    public void setFormDisplayInfos(Set<FormDisplayInfo> formDisplayInfos) {
        this.formDisplayInfos = formDisplayInfos;
    }

    public Set<Field> getFormFields() {
        return this.formFields;
    }

    public void setFormFields(Set<Field> formFields) {
        this.formFields = formFields;
    }

    public void setDataHolder(DataHolder holder) {
        if (holder == null) {
            return;
        }
        if (!(holder.getInputId() != null && holder.getInputId().trim().length() != 0 || holder.getOuputId() != null && holder.getOuputId().trim().length() != 0)) {
            return;
        }
        if (this.getDataHolderById(holder.getInputId()) != null || this.getDataHolderById(holder.getOuputId()) != null) {
            this.holders.remove(holder);
        }
        this.holders.add(holder);
    }

    public void removeDataHolder(String id) {
        if (id == null || id.trim().length() == 0) {
            return;
        }
        if (this.getDataHolderById(id) != null) {
            Iterator<DataHolder> it = this.holders.iterator();
            while (it.hasNext()) {
                DataHolder holder = it.next();
                if (!id.equals(holder.getUniqeId())) continue;
                it.remove();
            }
        }
    }

    public DataHolder getDataHolderByIds(String inputId, String outputId) {
        if (inputId == null || inputId.trim().length() == 0) {
            return null;
        }
        if (outputId == null || outputId.trim().length() == 0) {
            return null;
        }
        if (this.getHolders() != null) {
            for (DataHolder dataHolder : this.holders) {
                if (!inputId.equals(dataHolder.getInputId()) && !outputId.equals(dataHolder.getOuputId())) continue;
                return dataHolder;
            }
        }
        return null;
    }

    public DataHolder getDataHolderById(String srcId) {
        if (srcId == null || srcId.trim().length() == 0) {
            return null;
        }
        if (this.getHolders() != null) {
            for (DataHolder dataHolder : this.holders) {
                if (!srcId.equals(dataHolder.getUniqeId())) continue;
                return dataHolder;
            }
        }
        return null;
    }

    public String toString() {
        return "Form [" + this.getName() + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof Form)) {
            return false;
        }
        Form castOther = (Form)other;
        return this.getId().equals(castOther.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Field getField(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (this.getFormFields() != null) {
            for (Field field : this.formFields) {
                if (!name.equals(field.getFieldName())) continue;
                return field;
            }
        }
        return null;
    }

    protected String getDisplayModeText(String selector) {
        String text = null;
        if (this.getFormDisplayInfos() != null) {
            for (FormDisplayInfo dInfo : this.getFormDisplayInfos()) {
                if (!selector.equals(dInfo.getDisplayMode())) continue;
                text = dInfo.getDisplayData();
                break;
            }
        }
        return text;
    }

    protected void setDisplayModeText(String selector, String data) {
        if (this.getFormDisplayInfos() == null) {
            this.setFormDisplayInfos(new HashSet<FormDisplayInfo>());
        }
        FormDisplayInfo theTemplateInfo = null;
        for (FormDisplayInfo dInfo : this.getFormDisplayInfos()) {
            if (!selector.equals(dInfo.getDisplayMode())) continue;
            theTemplateInfo = dInfo;
            break;
        }
        if (theTemplateInfo == null) {
            theTemplateInfo = new FormDisplayInfo();
            this.getFormDisplayInfos().add(theTemplateInfo);
        }
        theTemplateInfo.setDisplayData(data);
        theTemplateInfo.setDisplayMode(selector);
    }

    public Set<DataHolder> getHolders() {
        return this.holders;
    }

    public void setHolders(Set<DataHolder> holders) {
        this.holders = holders;
    }

    public String getFormTemplate() {
        return this.getDisplayModeText(DISPLAY_MODE_TEMPLATE);
    }

    public void setFormTemplate(String data) {
        this.setDisplayModeText(DISPLAY_MODE_TEMPLATE, data);
    }

    public boolean containsFormField(String fieldName) {
        if (this.formFields != null && fieldName != null && !"".equals(fieldName)) {
            for (Field formField : this.formFields) {
                if (!formField.getFieldName().equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSynchronizationObject() {
        return ("JBPM Form " + this.getId()).intern();
    }

    public Set getFieldNames() {
        TreeSet<String> s = new TreeSet<String>();
        for (Field formField : this.formFields) {
            s.add(formField.getFieldName());
        }
        return s;
    }

    public int compareTo(Object o) {
        return this.id.compareTo(((Form)o).getId());
    }

    public boolean isFieldBinded(DataHolder dataHolder, String fieldName) {
        if (dataHolder == null || fieldName == null) {
            return false;
        }
        String inputBinding = dataHolder.getInputBinding(fieldName);
        String outputBinding = dataHolder.getOuputBinding(fieldName);
        for (Field field : this.formFields) {
            if (dataHolder.getInputId() != null && dataHolder.getInputId().trim().length() > 0 && !inputBinding.isEmpty() && inputBinding.equals(field.getInputBinding())) {
                return true;
            }
            if (dataHolder.getOuputId() == null || dataHolder.getOuputId().trim().length() <= 0 || outputBinding.isEmpty() || !outputBinding.equals(field.getOutputBinding())) continue;
            return true;
        }
        return false;
    }

    public String generateBindingStr(DataHolder dataHolder, String fieldName) {
        if (dataHolder == null || fieldName == null) {
            return "";
        }
        if (dataHolder.getDataFieldHolderById(fieldName) != null) {
            return "{" + dataHolder.getInputId() + "/" + fieldName + "}";
        }
        return "";
    }

    public String getDataFieldHolderNameFromBindingStr(String bindingStr) {
        if (bindingStr != null && bindingStr.indexOf(47) != -1 && bindingStr.length() > 1) {
            return bindingStr.substring(bindingStr.indexOf(47) + 1, bindingStr.length() - 1);
        }
        return "";
    }

    public DataHolder getDataHolderFromInputExpression(String inputExpression) {
        return this.getDataHolderFromExpression(inputExpression, true);
    }

    public DataHolder getDataHolderFromOutputExpression(String outputExpression) {
        return this.getDataHolderFromExpression(outputExpression, false);
    }

    protected DataHolder getDataHolderFromExpression(String bindingExpression, boolean checkInput) {
        if (bindingExpression == null) {
            return null;
        }
        for (DataHolder holder : this.holders) {
            if (checkInput && holder.containsInputBinding(bindingExpression)) {
                return holder;
            }
            if (checkInput || !holder.containsOutputBinding(bindingExpression)) continue;
            return holder;
        }
        return null;
    }

    public DataHolder getDataHolderByField(Field field) {
        if (field == null || field.getInputBinding() == null && field.getOutputBinding() == null) {
            return null;
        }
        for (DataHolder holder : this.holders) {
            if (holder.containsBinding(field.getInputBinding())) {
                return holder;
            }
            if (!holder.containsBinding(field.getOutputBinding())) continue;
            return holder;
        }
        return null;
    }

    public boolean containsHolder(DataHolder aholder) {
        for (DataHolder holder : this.holders) {
            if (!holder.equals(aholder)) continue;
            return true;
        }
        return false;
    }

    public HashMap getSubForms() {
        return this.subForms;
    }

    public void setSubForms(HashMap subForms) {
        this.subForms = subForms;
    }

    public void addSubForm(String path, Form subForm) {
        this.subForms.put(path, subForm);
    }
}

