/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.api.model.wrappers;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jbpm.formModeler.api.model.wrappers.I18nEntry;
import org.jbpm.formModeler.api.model.wrappers.I18nEntryComparator;
import org.jbpm.formModeler.api.model.wrappers.I18nEntryImpl;

public class I18nSet
extends AbstractMap
implements Serializable,
Comparable {
    private TreeSet entrySet = new TreeSet<I18nEntry>(new I18nEntryComparator());

    public I18nSet() {
    }

    @Override
    public Set entrySet() {
        return this.entrySet;
    }

    public I18nSet(Set s) {
        this.entrySet.addAll(s == null ? Collections.EMPTY_SET : s);
    }

    public I18nSet(Map m) {
        for (String lang : m.keySet()) {
            String value = (String)m.get(lang);
            this.entrySet.add(new I18nEntryImpl(lang, value));
        }
    }

    public boolean add(Object o) {
        if (o == null || o instanceof I18nEntry) {
            return this.entrySet.add(o);
        }
        return false;
    }

    public String getValue(String lang) {
        for (I18nEntry entry : this.entrySet) {
            if (!lang.equals(entry.getLang())) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public void setValue(String lang, String value) {
        Iterator it = this.entrySet.iterator();
        while (it.hasNext()) {
            I18nEntry entry = (I18nEntry)it.next();
            if (!lang.equals(entry.getLang())) continue;
            it.remove();
        }
        this.add(new I18nEntryImpl(lang, value));
    }

    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        I18nSet other = (I18nSet)o;
        for (String key : this.keySet()) {
            String otherValue;
            String value = this.getValue(key);
            int result = value.compareTo(otherValue = other.getValue(key));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public Map asMap() {
        return this;
    }

    public Iterator iterator() {
        return this.entrySet.iterator();
    }
}

