/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.fieldTypes.document.handling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.jbpm.document.Document;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.HTTPSettings;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.DoNothingResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.SendStreamResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="fdch")
@ApplicationScoped
public class FileDownloadHandler
extends BeanHandler {
    private Logger log = LoggerFactory.getLogger(FileDownloadHandler.class);
    @Inject
    private HTTPSettings httpSettings;
    @Inject
    private DocumentStorageService fileStorageService;

    public CommandResponse actionDownload(CommandRequest request) {
        try {
            byte[] docContent;
            Document doc;
            String content = request.getRequestObject().getParameter("content");
            if (!StringUtils.isEmpty((String)content) && (doc = this.fileStorageService.getDocument(content)) != null && (docContent = doc.getContent()) != null) {
                return new SendStreamResponse((InputStream)new ByteArrayInputStream(docContent), "inline;filename=" + URLEncoder.encode(doc.getName(), this.httpSettings.getEncoding()));
            }
        }
        catch (Exception e) {
            this.log.warn("Error trying to get file content: ", (Throwable)e);
        }
        return new DoNothingResponse();
    }

    public boolean isEnabledForActionHandling() {
        return true;
    }
}

