/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.fieldTypes.document.handling;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.document.service.impl.util.DocumentDownloadLinkGenerator;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.components.renderer.FormRenderContextManagerImpl;
import org.jbpm.formModeler.fieldTypes.document.handling.JBPMDocumentFieldTypeHandler;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ControllerStatus.class})
public class JBPMDocumentFieldTypeHandlerTest {
    private static final String NAMESPACE = "namespace";
    private static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    private static final String FIELD_NAME = "myDocument";
    private static final String DOC_ID = "docId";
    private static final String DOC_NAME = "doc.txt";
    private static final long DOC_SIZE = 1234L;
    private static final Date DOC_LAST_MODIFIED = new Date();
    private static final String DOC_LINK = "http://mydocs/doc.txt";
    private static final String FILE_INPUT = "<input type=\"file\" name=\"myDocument\" id=\"myDocument\"";
    private JBPMDocumentFieldTypeHandler handler;
    @Mock
    private ControllerStatus controllerStatus;
    @Mock
    private CommandRequest commandRequest;
    @Mock
    private HttpServletRequest request;
    @Mock
    private Field field;
    @Mock
    private FormRenderContextManagerImpl contextManager;
    @Mock
    private FormRenderContext context;
    private Document document;

    @Before
    public void init() {
        this.document = new DocumentImpl(DOC_ID, DOC_NAME, 1234L, DOC_LAST_MODIFIED, DOC_LINK);
        Mockito.when((Object)this.field.getFieldName()).thenReturn((Object)FIELD_NAME);
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)"");
        Mockito.when((Object)this.commandRequest.getRequestObject()).thenReturn((Object)this.request);
        Mockito.when((Object)this.controllerStatus.getRequest()).thenReturn((Object)this.commandRequest);
        Mockito.when((Object)this.context.getServerTemplateId()).thenReturn((Object)SERVER_TEMPLATE_ID);
        Mockito.when((Object)this.contextManager.getRootContext(Mockito.anyString())).thenReturn((Object)this.context);
        PowerMockito.mockStatic(ControllerStatus.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ControllerStatus.lookup()).thenReturn((Object)this.controllerStatus);
        this.handler = (JBPMDocumentFieldTypeHandler)Mockito.spy((Object)new JBPMDocumentFieldTypeHandler((FormRenderContextManager)this.contextManager));
        this.handler.init();
    }

    @Test
    public void testGetInputHTML() {
        String result = this.handler.getInputHTML((Object)this.document, this.field, FIELD_NAME, NAMESPACE, Boolean.valueOf(false));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().contains(new CharSequence[]{FILE_INPUT}).contains(new CharSequence[]{DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID)});
    }

    @Test
    public void testGetInputHTMLReadOnly() {
        String result = this.handler.getInputHTML((Object)this.document, this.field, FIELD_NAME, NAMESPACE, Boolean.valueOf(true));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().contains(new CharSequence[]{FILE_INPUT}).contains(new CharSequence[]{"disabled=\"disabled\""}).contains(new CharSequence[]{DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID)});
    }

    @Test
    public void testGetInputHTMLNullDocument() {
        String result = this.handler.getInputHTML(null, this.field, FIELD_NAME, NAMESPACE, Boolean.valueOf(false));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().contains(new CharSequence[]{FILE_INPUT}).doesNotContain((CharSequence)DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID));
    }

    @Test
    public void testGetInputHTMLEmptyDocumentId() {
        this.document.setIdentifier(null);
        String result = this.handler.getInputHTML((Object)this.document, this.field, FIELD_NAME, NAMESPACE, Boolean.valueOf(false));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().contains(new CharSequence[]{FILE_INPUT}).doesNotContain((CharSequence)DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID));
    }

    @Test
    public void testGetShowHTML() {
        String result = this.handler.getShowHTML((Object)this.document, this.field, FIELD_NAME, NAMESPACE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().doesNotContain((CharSequence)FILE_INPUT).contains(new CharSequence[]{DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID)});
    }

    @Test
    public void testGetShowHTMLNullDocument() {
        String result = this.handler.getShowHTML(null, this.field, FIELD_NAME, NAMESPACE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().doesNotContain((CharSequence)FILE_INPUT).doesNotContain((CharSequence)DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID));
    }

    @Test
    public void testGetShowHTMLEmptyDocumentId() {
        this.document.setIdentifier(null);
        String result = this.handler.getShowHTML((Object)this.document, this.field, FIELD_NAME, NAMESPACE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty().doesNotContain((CharSequence)FILE_INPUT).doesNotContain((CharSequence)DocumentDownloadLinkGenerator.generateDownloadLink((String)SERVER_TEMPLATE_ID, (String)DOC_ID));
    }
}

