/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Project;
import org.jbpm.formModeler.api.client.FormEditorContext;
import org.jbpm.formModeler.api.client.FormEditorContextManager;
import org.jbpm.formModeler.api.model.RangeProvider;
import org.jbpm.formModeler.editor.service.FormModelerService;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.util.URIUtil;

public class RangeProviderForm
implements RangeProvider {
    private Logger log = LoggerFactory.getLogger(RangeProviderForm.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private KieProjectService projectService;
    @Inject
    protected FormModelerService formModelerService;
    @Inject
    protected FormEditorContextManager formEditorContextManager;

    public String getType() {
        return "{$range_provider_form}";
    }

    public Map<String, String> getRangesMap(String namespace) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        FormEditorContext context = this.formEditorContextManager.getRootEditorContext(namespace);
        if (context == null) {
            return treeMap;
        }
        org.uberfire.backend.vfs.Path currentForm = null;
        try {
            currentForm = Paths.convert((Path)this.ioService.get(new URI(context.getPath())));
        }
        catch (Exception e) {
            this.log.warn("Unable to load asset on '" + context.getPath() + "': ", (Throwable)e);
            return treeMap;
        }
        String currentFormDirUri = this.getFormDirUri(currentForm);
        String currentFormName = currentForm.getFileName();
        Project project = this.projectService.resolveProject(currentForm);
        FileUtils utils = FileUtils.getInstance();
        ArrayList<Path> nioPaths = new ArrayList<Path>();
        nioPaths.add(Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()));
        Collection forms = utils.scan(this.ioService, nioPaths, "form", true);
        for (FileUtils.ScanResult form : forms) {
            org.uberfire.backend.vfs.Path formPath = Paths.convert((Path)form.getFile());
            String formDirUri = this.getFormDirUri(formPath);
            String formName = formPath.getFileName();
            if (!currentFormDirUri.equals(formDirUri) || formName.startsWith(".") || currentFormName.equals(formName)) continue;
            treeMap.put(formPath.getFileName(), formPath.getFileName());
        }
        return treeMap;
    }

    private String getFormDirUri(org.uberfire.backend.vfs.Path formPath) {
        String fileName = formPath.getFileName();
        try {
            fileName = URIUtil.encode((String)fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formPath.toURI().substring(0, formPath.toURI().lastIndexOf(fileName) - 1);
    }
}

