/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.DataFieldHolder;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.DataHolderIndexGenerator;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.FieldIndexGenerator;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.FormIndexGenerator;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueDataHolderFieldIndexTerm;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueDataHolderIndexTerm;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueDataHolderTypeIndexTerm;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueFieldIndexTerm;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueFieldTypeIndexTerm;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueFormIndexTerm;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.valueterms.ValueSubFormIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class FormVisitor {
    private final DefaultIndexBuilder builder;
    private final Form form;

    public FormVisitor(DefaultIndexBuilder builder, Form form) {
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.form = (Form)PortablePreconditions.checkNotNull((String)"form", (Object)form);
    }

    public Set<Pair<String, String>> visit() {
        this.visit(this.form);
        return this.builder.build();
    }

    protected void visit(Form form) {
        this.builder.addGenerator((IndexElementsGenerator)new FormIndexGenerator(new ValueFormIndexTerm(form.getName())));
        for (Field field : form.getFormFields()) {
            this.visit(field);
        }
        for (DataHolder dataHolder : form.getHolders()) {
            this.visit(dataHolder);
        }
    }

    protected void visit(DataHolder dataHolder) {
        DataHolderIndexGenerator indexGenerator = new DataHolderIndexGenerator(new ValueDataHolderIndexTerm(dataHolder.getUniqeId()), new ValueDataHolderTypeIndexTerm(dataHolder.getInfo()));
        if (dataHolder.canHaveChildren()) {
            ArrayList<ValueDataHolderFieldIndexTerm> fieldTerms = new ArrayList<ValueDataHolderFieldIndexTerm>();
            for (DataFieldHolder field : dataHolder.getFieldHolders()) {
                if (!this.form.isFieldBinded(dataHolder, field.getId())) continue;
                fieldTerms.add(new ValueDataHolderFieldIndexTerm(field.getId()));
            }
            indexGenerator.setDataHolderFieldsIndexTerms(fieldTerms);
        }
        this.builder.addGenerator((IndexElementsGenerator)indexGenerator);
    }

    protected void visit(Field field) {
        FieldIndexGenerator indexGenerator;
        DataHolder holder = field.getForm().getDataHolderByField(field);
        if (holder != null) {
            int slash;
            String bindingExpression;
            String holderFieldId;
            DataFieldHolder holderField;
            ValueDataHolderIndexTerm holderIndexTerm = new ValueDataHolderIndexTerm(holder.getUniqeId());
            indexGenerator = holder.canHaveChildren() ? ((holderField = holder.getDataFieldHolderById(holderFieldId = (bindingExpression = (String)StringUtils.defaultIfEmpty((CharSequence)field.getInputBinding(), (CharSequence)field.getOutputBinding())).substring((slash = bindingExpression.indexOf("/")) + 1))) != null ? new FieldIndexGenerator(new ValueFieldIndexTerm(field.getFieldName()), new ValueFieldTypeIndexTerm(holderField.getClassName()), holderIndexTerm, new ValueDataHolderFieldIndexTerm(holderFieldId)) : new FieldIndexGenerator(new ValueFieldIndexTerm(field.getFieldName()), new ValueFieldTypeIndexTerm(holder.getInfo()), holderIndexTerm)) : new FieldIndexGenerator(new ValueFieldIndexTerm(field.getFieldName()), new ValueFieldTypeIndexTerm(holder.getInfo()), holderIndexTerm);
        } else {
            indexGenerator = new FieldIndexGenerator(new ValueFieldIndexTerm(field.getFieldName()), new ValueFieldTypeIndexTerm(field.getFieldType().getFieldClass()));
        }
        if (!StringUtils.isEmpty((CharSequence)field.getDefaultSubform())) {
            indexGenerator.setDefaultSubform(new ValueSubFormIndexTerm(field.getDefaultSubform()));
        }
        if (!StringUtils.isEmpty((CharSequence)field.getPreviewSubform())) {
            indexGenerator.setPreviewSubform(new ValueSubFormIndexTerm(field.getPreviewSubform()));
        }
        if (!StringUtils.isEmpty((CharSequence)field.getTableSubform())) {
            indexGenerator.setTableSubform(new ValueSubFormIndexTerm(field.getTableSubform()));
        }
        this.builder.addGenerator((IndexElementsGenerator)indexGenerator);
    }
}

