/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.rendering.FormFinder;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SubformFinderServiceImpl
implements SubformFinderService {
    private Logger log = LoggerFactory.getLogger(SubformFinderService.class);
    @Inject
    private Instance<FormFinder> findersInstances;
    protected Set<FormFinder> finders;

    @PostConstruct
    protected void init() {
        this.finders = new TreeSet<FormFinder>(new Comparator<FormFinder>(){

            @Override
            public int compare(FormFinder o1, FormFinder o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (FormFinder p : this.findersInstances) {
            this.finders.add(p);
        }
    }

    public Form getForm(String ctxUID) {
        for (FormFinder finder : this.finders) {
            Form form = finder.getForm(ctxUID);
            if (form == null) continue;
            return form;
        }
        return null;
    }

    public Form getFormByPath(String formPath, String ctxUID) {
        for (FormFinder finder : this.finders) {
            Form form = finder.getFormByPath(ctxUID, formPath);
            if (form == null) continue;
            return form;
        }
        return null;
    }

    public Form getFormById(long formId, String ctxUID) {
        for (FormFinder finder : this.finders) {
            Form form = finder.getFormById(ctxUID, formId);
            if (form == null) continue;
            return form;
        }
        return null;
    }
}

