/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.formModeler.api.client.FormEditorContext;
import org.jbpm.formModeler.api.client.FormEditorContextManager;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormManager;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.jbpm.formModeler.editor.model.FormEditorContextTO;
import org.jbpm.formModeler.editor.model.FormModelerContent;
import org.jbpm.formModeler.editor.service.FormModelerService;
import org.kie.workbench.common.services.backend.service.KieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class FormModelerServiceImpl
extends KieService<FormModelerContent>
implements FormModelerService {
    private Logger log = LoggerFactory.getLogger(FormModelerServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private RenameService renameService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private SubformFinderService subformFinderService;
    @Inject
    private FormManager formManager;
    @Inject
    private FormSerializationManager formSerializationManager;
    @Inject
    private FormEditorContextManager formEditorContextManager;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;

    public void changeContextPath(String ctxUID, org.uberfire.backend.vfs.Path path) {
        if (StringUtils.isEmpty((CharSequence)ctxUID)) {
            return;
        }
        this.formEditorContextManager.getFormEditorContext(ctxUID).setPath(Paths.convert((org.uberfire.backend.vfs.Path)path).toUri().toString());
    }

    public void removeEditingForm(String ctxUID) {
        this.formEditorContextManager.removeEditingForm(ctxUID);
    }

    public FormEditorContextTO reloadContent(org.uberfire.backend.vfs.Path path, String ctxUID) {
        try {
            Form form = this.findForm(Paths.convert((org.uberfire.backend.vfs.Path)path));
            FormEditorContext context = this.formEditorContextManager.getFormEditorContext(ctxUID);
            context.setForm(form);
            return new FormEditorContextTO(context.getUID());
        }
        catch (Exception e) {
            this.log.warn("Error loading form " + path.toURI(), (Throwable)e);
            return null;
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, FormEditorContextTO content, Metadata metadata, String comment) {
        FormEditorContext ctx = this.formEditorContextManager.getFormEditorContext(content.getCtxUID());
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.formSerializationManager.generateFormXML(ctx.getForm()), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
        return path;
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        this.deleteService.delete(path, comment);
    }

    public org.uberfire.backend.vfs.Path createForm(org.uberfire.backend.vfs.Path path, String formName) {
        Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)path).resolve(formName);
        try {
            if (this.ioService.exists(kiePath)) {
                throw new FileAlreadyExistsException(kiePath.toString());
            }
            Form form = this.formManager.createForm(formName);
            this.ioService.write(kiePath, this.formSerializationManager.generateFormXML(form), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("")});
            return Paths.convert((Path)kiePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public FormModelerContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (FormModelerContent)super.loadContent(path);
    }

    protected FormModelerContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        try {
            Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            Form form = this.findForm(kiePath);
            FormEditorContextTO contextTO = new FormEditorContextTO();
            if (form == null) {
                contextTO.setLoadError(true);
                form = this.formManager.createForm(path.getFileName());
            }
            String formPath = kiePath.toUri().toString();
            FormEditorContext context = this.formEditorContextManager.newContext(form, formPath);
            contextTO.setCtxUID(context.getUID());
            FormModelerContent result = new FormModelerContent();
            result.setContextTO(contextTO);
            result.setPath(path);
            result.setOverview(overview);
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return result;
        }
        catch (Exception e) {
            this.log.warn("Error loading form " + path.toURI(), (Throwable)e);
            return null;
        }
    }

    protected Form findForm(Path path) throws Exception {
        String xml = this.ioService.readAllString(path).trim();
        return this.formSerializationManager.loadFormFromXML(xml, path.toUri().toString());
    }
}

