/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.jbpm.formModeler.panels.modeler.backend.indexing.model.terms.FormIndexTerm;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindFormsQuery
implements NamedQuery {
    @Inject
    private DefaultResponseBuilder responseBuilder;

    public String getName() {
        return "FindFormsQuery";
    }

    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new FormIndexTerm());
            }
        };
    }

    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        if (terms.size() != 1) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'form_name'.");
        }
        Map<String, ValueIndexTerm> normalizedTerms = this.normalizeTerms(terms);
        ValueIndexTerm ruleTerm = normalizedTerms.get("form_name");
        if (ruleTerm == null) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'form_name'.");
        }
        BasicQueryBuilder builder = new BasicQueryBuilder();
        if (useWildcards) {
            builder.useWildcards();
        }
        builder.addTerm(ruleTerm);
        return builder.build();
    }

    private Map<String, ValueIndexTerm> normalizeTerms(Set<ValueIndexTerm> terms) {
        HashMap<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();
        for (ValueIndexTerm term : terms) {
            normalizedTerms.put(term.getTerm(), term);
        }
        return normalizedTerms;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

