/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.editor.type.FormResourceTypeDefinition;
import org.jbpm.formModeler.panels.modeler.backend.indexing.FormIndexVisitor;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class FormIndexer
extends AbstractFileIndexer {
    @Inject
    protected FormSerializationManager formSerializationManager;
    @Inject
    protected FormResourceTypeDefinition formType;

    public boolean supportsPath(Path path) {
        return this.formType.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        Form form = this.formSerializationManager.loadFormFromXML(this.ioService.readAllString(path).trim(), path.toUri().toString());
        DefaultIndexBuilder builder = this.getIndexBuilder(path);
        if (builder == null) {
            return null;
        }
        FormIndexVisitor formIndexVisitor = new FormIndexVisitor(form);
        formIndexVisitor.visit();
        this.addReferencedResourcesToIndexBuilder(builder, formIndexVisitor);
        return builder;
    }
}

